//
// PDFlib client: fill Blocks with PPS to create a business card
// Required software: PDFlib Personalization Server (PPS)
//

using System;
using System.Text;
using PDFlib_dotnet;

struct blockdata
{
    public string name, value;

    // Constructor:
    public blockdata(string name, string value)
    {
        this.name = name;
        this.value = value;
    }
}

class businesscard {
    static void Main(string[] args)
    {
        PDFlib p = null;
        int i, blockcontainer, page, pagecount, pageno;
        string infile = "boilerplate.pdf";

        // This is where font/image/PDF input files live. Adjust as necessary.
        //
        // Note that this directory must also contain the font files
        //
        string searchpath = "../../../data";

        // By default annotations are also imported. In some cases this
        // requires the Noto fonts for creating annotation appearance streams.
        // We therefore set the searchpath to also point to the font directory.
        //
        string fontpath = "../../../../resource/font";

        blockdata[] dataset = {
             new blockdata( "name",                    "Victor Kraxi" ),
             new blockdata( "business.title",          "Chief Paper Officer" ),
             new blockdata( "business.address.line1",  "17, Aviation Road" ),
             new blockdata( "business.address.city",   "Paperfield" ),
             new blockdata( "business.telephone.voice","phone +1 234 567-89" ),
             new blockdata( "business.telephone.fax",  "fax +1 234 567-98" ),
             new blockdata( "business.email",          "victor@kraxi.com" ),
             new blockdata( "business.homepage",       "www.kraxi.com" )
        };
        int BLOCKCOUNT = dataset.Length;


        try
        {
            p = new PDFlib();

            if (p.begin_document("businesscard.pdf", "") == -1) {
                Console.WriteLine("Error: {0}\n", p.get_errmsg());
                return;
            }

            // This means we must check return values of load_font() etc.
            // Set the search path for fonts and PDF files 
            p.set_option("errorpolicy=return SearchPath={{" + searchpath + "}}");

            p.set_option("SearchPath={{" + fontpath + "}}");

            p.set_info("Creator", "businesscard");
            p.set_info("Author", "Thomas Merz");
            p.set_info("Title", "PDFlib Block processing sample");

            blockcontainer = p.open_pdi_document(infile, "");
            if (blockcontainer == -1) {
                Console.WriteLine("Error: {0}\n", p.get_errmsg());
                return;
            }
            pagecount = (int) p.pcos_get_number(blockcontainer, "length:pages");

            for (pageno = 1; pageno <= pagecount; pageno++){

                page = p.open_pdi_page(blockcontainer, pageno, "");

                if (page == -1) {
                    Console.WriteLine("Error: {0}\n", p.get_errmsg());
                    return;
                }

                p.begin_page_ext(20, 20, "");   // dummy page size

                // This will adjust the page size to the size of the input page
                p.fit_pdi_page(page, 0, 0, "adjustpage");

                // Fill all text Blocks with dynamic data
                for (i = 0; i < BLOCKCOUNT; i++)
                {
                    if (p.fill_textblock(page, dataset[i].name, dataset[i].value, "") == -1)
                    {
                        Console.WriteLine("Warning: {0}\n", p.get_errmsg());
                    }
                }

                p.end_page_ext("");
                p.close_pdi_page(page);
            }

            p.end_document("");
            p.close_pdi_document(blockcontainer);

        }

        catch (PDFlibException e)
        {
            // caught exception thrown by PDFlib
            Console.WriteLine("PDFlib exception occurred in businesscard sample:");
            Console.WriteLine("[{0}] {1}: {2}\n", e.get_errnum(),
                    e.get_apiname(), e.get_errmsg());
        } finally {
            if (p != null) {
                p.Dispose();
            }
        }
    }
}
