//
// PDFlib client: hello example in C#
//

using System;
using System.Text;
using PDFlib_dotnet;

class Hello {
    static void Main(string[] args) {

        PDFlib p = null;
        /* This is where the data files are. Adjust as necessary. */
        string searchpath = "../../../data";

        try 
        {
            p = new PDFlib();

            // This means we must check return values of load_font() etc.
            p.set_option("errorpolicy=return");

            // Set the search path for font files 
            p.set_option("SearchPath={{" + searchpath +"}}");

            if (p.begin_document("hello.pdf", "") == -1) 
            {
                Console.WriteLine("Error: {0}\n", p.get_errmsg());
                return;
            }

            p.set_info("Creator", "hello.cs");
            p.set_info("Author", "Rainer Schaaf");
            p.set_info("Title", "Hello World (.NET/C#)!");

            p.begin_page_ext(0,0, "width=a4.width height=a4.height");

            string fontopt =
                "fontname=NotoSerif-Regular fontsize=24";

            p.fit_textline("Hello world!", 50, 700, fontopt);
            p.fit_textline("(says .NET/C#)",  50, 676, fontopt);

            p.end_page_ext("");

            p.end_document("");
        }

        catch (PDFlibException e)
        {
            // caught exception thrown by PDFlib
            Console.WriteLine("PDFlib exception occurred in hello sample:\n");
            Console.WriteLine("[{0}] {1}: {2}\n", e.get_errnum(),
                    e.get_apiname(), e.get_errmsg());
        } finally {
            if (p != null) {
                p.Dispose();
            }
        }
    }
}
