//
// PDFlib client: image example in C#
//

using System;
using PDFlib_dotnet;

class Image {
    static void Main(string[] args) {
        PDFlib p = null;
        int image;       
        string imagefile = "nesrin.jpg";
        // This is where font/image/PDF input files live. Adjust as necessary.
        string searchpath = "../../../data";

        try
        {
            p = new PDFlib();

            // This means we must check return values of load_image() etc.
            p.set_option("errorpolicy=return");

            // Set the search path for fonts and PDF files 
            p.set_option("SearchPath={{" + searchpath + "}}");

            if (p.begin_document("image.pdf", "") == -1) {
                Console.WriteLine("Error: {0}\n", p.get_errmsg());
                return;
            }

            p.set_info("Creator", "image");
            p.set_info("Author", "Thomas Merz");
            p.set_info("Title", "image sample");

            image = p.load_image("auto", imagefile, "");

            if (image == -1) {
                Console.WriteLine("Error: {0}\n", p.get_errmsg());
                return;
            }

            // dummy page size, will be adjusted by p.fit_image() 
            p.begin_page_ext(0, 0, "width=a4.width height=a4.height");
            p.fit_image(image, (float) 0.0, (float) 0.0, "adjustpage");
            p.close_image(image);

            p.end_page_ext("");

            p.end_document("");
        }

        catch (PDFlibException e)
        {
            // caught exception thrown by PDFlib
            Console.WriteLine("PDFlib exception occurred in image sample:");
            Console.WriteLine("[{0}] {1}: {2}\n", e.get_errnum(),
                    e.get_apiname(), e.get_errmsg());
        } finally {
            if (p != null) {
                p.Dispose();
            }
        }
    }
}
