//
// formfields starter:
// create a linearized PDF (for fast delivery over the Web, also known
// as "fast Web view") which is encrypted and contains some form fields.
// A few lines of JavaScript are inserted as "page open" action to
// automatically populate the date field with the current date.
//
// Required data: font file
//

using System;
using System.Text;
using PDFlib_dotnet;

class starter_formfields {
    static void Main(string[] args) {

        PDFlib p = null;
        string optlist;
        int font, action;
        double llx=150, lly=550, urx=350, ury=575;
        String searchpath = "../../../data";

        /* JavaScript for automatically filling the date into a form field */
        string js =
                "var d = util.printd(\"mm/dd/yyyy\", new Date());" +
                "var date = this.getField(\"date\");" +
                "date.value = d;";

        try 
        {
            p = new PDFlib();

            // This means we must check return values of load_font() etc.
            p.set_option("errorpolicy=return");

            // Set the search path for fonts and PDF files 
            p.set_option("SearchPath={{" + searchpath + "}}");

            /* Prevent changes with a master password */
            optlist = "linearize masterpassword=pdflib permissions={nomodify}";

            if (p.begin_document("starter_formfields.pdf", optlist) == -1)
                    throw new Exception("Error: " + p.get_errmsg());

            p.set_info("Creator", "PDFlib starter sample");
            p.set_info("Title", "starter_formfields");

            optlist = "script[" + js.Length + "]={" + js + "}";
            action = p.create_action("JavaScript", optlist);

            optlist = "width=a4.width height=a4.height action={open=" + action + "}";
            p.begin_page_ext(0, 0, optlist);

            font = p.load_font("NotoSerif-Regular", "winansi", "simplefont nosubsetting");
            if (font == -1)
                throw new Exception("Error: " + p.get_errmsg());
            p.setfont(font, 24);

            p.fit_textline("Date: ", 125, lly+5, "position={right bottom}");

            /* The tooltip will be used as rollover text for the field */
            optlist =
                    "tooltip={Date (will be filled automatically)} " +
                    "bordercolor={gray 0} font=" + font;
            p.create_field(llx, lly, urx, ury, "date", "textfield", optlist);

            lly-=100; ury-=100;
            p.fit_textline("Name: ", 125, lly+5, "position={right bottom}");

            optlist = "tooltip={Enter your name here} " +
                    "bordercolor={gray 0} font=" + font;
            p.create_field(llx, lly, urx, ury, "name", "textfield", optlist);

            p.end_page_ext("");

            p.end_document("");

        }

        catch (PDFlibException e)
        {
            // caught exception thrown by PDFlib
            Console.WriteLine("PDFlib exception occurred:\n");
            Console.WriteLine("[{0}] {1}: {2}\n", e.get_errnum(),
                    e.get_apiname(), e.get_errmsg());
            return;
        }
    }
}
