//
// PDF merge starter:
// Merge pages from multiple PDF documents (including annotations)
//
// Required software: PDFlib+PDI or PDFlib Personalization Server (PPS)
// Required data: PDF documents
//

using System;
using System.Text;
using PDFlib_dotnet;


class starter_pdfmerge {
    static void Main(string[] args) {
        /* This is where the data files are. Adjust as necessary. */
        string searchpath = "../../../data";

        // By default annotations are also imported. In some cases this
        // requires the Noto fonts for creating annotation appearance streams.
        // We therefore set the searchpath to also point to the font directory.
        //
        string fontpath = "../../../../resource/font";


        PDFlib p = null;
        string[] pdffiles =
        {
                "markup_annotations.pdf",
                "pCOS-datasheet.pdf"
        };
        int i;


        try     
        {
            p = new PDFlib();

            // This means we must check return values of load_font() etc.
            p.set_option("errorpolicy=return");

            // Set the search path for fonts and PDF files 
            p.set_option("SearchPath={{" + searchpath + "}}");

            p.set_option("SearchPath={{" + fontpath + "}}");

            if (p.begin_document("starter_pdfmerge.pdf", "") == -1)
                    throw new Exception("Error: " + p.get_errmsg());

            p.set_info("Creator", "PDFlib starter sample");
            p.set_info("Title", "starter_pdfmerge");

            for (i=0; i < pdffiles.Length; i++)
            {
                int indoc, endpage, pageno, page;

                /* Open the input PDF */
                indoc = p.open_pdi_document(pdffiles[i], "");
                if (indoc == -1)
                {
                    Console.WriteLine("Error: " + p.get_errmsg());
                    continue;
                }

                endpage = (int) p.pcos_get_number(indoc, "length:pages");

                /* Loop over all pages of the input document */
                for (pageno = 1; pageno <= endpage; pageno++)
                {
                    page = p.open_pdi_page(indoc, pageno, "");

                    if (page == -1)
                    {
                            Console.WriteLine("Error: " + p.get_errmsg());
                            continue;
                    }
                    /* Dummy page size; will be adjusted later */
                    p.begin_page_ext(10, 10, "");

                    /* Create a bookmark with the file name */
                    if (pageno == 1)
                            p.create_bookmark(pdffiles[i], "");

                    /* Place the imported page on the output page, and
                     * adjust the page size. If the page contains annotations
                     * these are also imported.
                     */
                    p.fit_pdi_page(page, 0, 0, "adjustpage");
                    p.close_pdi_page(page);

                    p.end_page_ext("");
                }
		p.close_pdi_document(indoc);
            }
            p.end_document("");
    
        }
        catch (PDFlibException e)
        {
            // caught exception thrown by PDFlib
            Console.WriteLine("PDFlib exception occurred:");
            Console.WriteLine("[{0}] {1}: {2}\n", e.get_errnum(),
                    e.get_apiname(), e.get_errmsg());
        } finally {
            if (p != null) {
                p.Dispose();
            }
        }
    }
}
