//
// PDF/X-3 starter:
// Create PDF/X-3 conforming output
//
// Required data: font file, image file, ICC profile
//                (see www.pdflib.com for output intent ICC profiles)
//

using System;
using System.Text;
using PDFlib_dotnet;

class starter_pdfx3 {
    static void Main(string[] args) {
        /* This is where the data files are. Adjust as necessary.*/
        String searchpath = "../../../data";

        PDFlib p = null;
        String imagefile = "nesrin.jpg";

        int font, image, spot;

        try
        {
            p = new PDFlib();

            // This means we must check return values of load_font() etc.
            p.set_option("errorpolicy=return");

            // Set the search path for fonts and PDF files 
            p.set_option("SearchPath={{" + searchpath + "}}");

            if (p.begin_document("starter_pdfx3.pdf", "pdfx=PDF/X-3:2003") == -1)
                    throw new Exception("Error: " + p.get_errmsg());

            p.set_info("Creator", "PDFlib starter sample");
            p.set_info("Title", "starter_pdfx3");

            if (p.load_iccprofile("ISOcoated_v2_eci.icc", "usage=outputintent") == -1) {
                throw new Exception( "Error: " +  p.get_errmsg() + "\n" 
                + "See www.pdflib.com for output intent ICC profiles.\n");
            }


            p.begin_page_ext(0,0, "width=a4.width height=a4.height");

            font = p.load_font("NotoSerif-Regular", "unicode", "");
            if (font == -1)
                throw new Exception("Error: " + p.get_errmsg());
            p.setfont(font, 24);

            spot = p.makespotcolor("PANTONE 123 C");
            p.setcolor("fill", "spot", spot, 1.0, 0.0, 0.0);
            p.fit_textline("PDF/X-3:2003 starter", 50, 700, "");

            image = p.load_image("auto", imagefile, "");

            if (image == -1)
                    throw new Exception("Error: " + p.get_errmsg());

            p.fit_image(image, 0.0, 0.0, "scale=0.5");

            p.end_page_ext("");

            p.end_document("");

        }

        catch (PDFlibException e)
        {
            // caught exception thrown by PDFlib
            Console.WriteLine("PDFlib exception occurred:");
            Console.WriteLine("[{0}] {1}: {2}\n", e.get_errnum(),
                    e.get_apiname(), e.get_errmsg());
        } finally {
            if (p != null) {
                p.Dispose();
            }
        }
    }
}
