//
// PDF portfolio starter:
// Package multiple PDF and other documents into a PDF portfolio.
// The documents in the portfolio will be assigned predefined
// and custom metadata fields; for the custom fields a schema description
// is created.
//
// Required data: PDF and other input documents
//

using System;
using System.Text;
using PDFlib_dotnet;

struct portfolio
{
    public string filename;
    public string description;
    public string status;
    public int id;
    // Constructor
    public portfolio(string filename, string description, string status,
        int id)
    {
        this.filename = filename;
        this.description = description;
        this.status = status;
        this.id = id;
    }
};

class starter_portfolio {
  static int Main(string[] args)
  {
    /* This is where the data files are. Adjust as necessary. */
    string searchpath = "../../../data";
    StringBuilder optlist = new StringBuilder();;
    int i, font, folder;
    PDFlib p = null;

    /* The documents for the Portfolio along with description and metadata */
    portfolio[] pf =
    {
        new portfolio(
            "nesrin.jpg",
            "Zabrisky point",
            "archived",
            300
        ),
        new portfolio(
            "markup_annotations.pdf",
            "PDF sample with markup annotations",
            "published",
            101
        ),
        new portfolio(
            "pCOS-datasheet.pdf",
            "PDF Information Retrieval Tool",
            "published",
            104
        )
    };
    int n_files = pf.Length;

    try
    {
        /* create a new PDFlib object */
        p = new PDFlib();

        // This means we must check return values of load_font() etc.
        p.set_option("errorpolicy=return");

        // Set the search path for fonts and PDF files 
        p.set_option("SearchPath={{" + searchpath + "}}");

        if (p.begin_document("starter_portfolio.pdf",
                "") == -1)
        {
            Console.WriteLine("Error: {0}\n", p.get_errmsg());
            return(2);
        }

        p.set_info("Creator", "PDFlib starter sample");
        p.set_info("Title", "starter_portfolio");

        /* Insert two files in the root folder along with their description
         * and the following custom fields:
         * status   string describing the document status
         * id       numerical identifier, prefixed with "PHX"
         */
        for (i = 0; i < 2; i++)
        {
            optlist.Length = 0;
            optlist.Append("description={");
            optlist.AppendFormat("{0}", pf[i].description);
            optlist.Append("} fieldlist={ {key=status value=");
            optlist.AppendFormat("{0}", pf[i].status);
            optlist.Append("} {key=id value=");
            optlist.AppendFormat("{0}", pf[i].id);
            optlist.Append(" prefix=PHX type=text} }");

            /* -1 means root folder */
            p.add_portfolio_file(-1, pf[i].filename, optlist.ToString());
        }

        /* Create the "datasheets" folder in the root folder */
        folder = p.add_portfolio_folder(-1, "datasheets", 
            "description={Folder with datasheets}");

        /* Insert documents in the "datasheets" folder along with
         * description and custom fields
         */
        for (i = 2; i < n_files; i++)
        {
            optlist.Length = 0;
            optlist.Append("description={");
            optlist.AppendFormat("{0}", pf[i].description);
            optlist.Append("} fieldlist={ {key=status value=");
            optlist.AppendFormat("{0}", pf[i].status);
            optlist.Append("} {key=id value=");
            optlist.AppendFormat("{0}", pf[i].id);
            optlist.Append(" prefix=PHX type=text} }");

            /* Add the file to the "datasheets" folder */
            p.add_portfolio_file(folder, pf[i].filename, optlist.ToString());
        }

        /* Create a single-page document as cover sheet */
        p.begin_page_ext(0, 0, "width=a4.width height=a4.height");

        font = p.load_font("NotoSerif-Regular", "unicode", "");
        if (font == -1)
        {
            Console.WriteLine("Error: {0}\n", p.get_errmsg());
            return(2);
        }

        p.setfont(font, 24);
        p.fit_textline("Welcome to the PDFlib Portfolio sample!", 50, 700, "");

        p.end_page_ext("");

        /* Set options for Portfolio display */
        optlist.Length = 0;
        optlist.Append( "portfolio={initialview=detail ");

        /* Add schema definition for Portfolio metadata */
        optlist.Append(
        "schema={ " +
        /* Some predefined fields are included here to make them visible. */
        "{order=1 label=Name key=_filename visible editable} " +
        "{order=2 label=Description key=_description visible} " +
        "{order=3 label=Size key=_size visible} " +
        "{order=4 label={Last edited} key=_moddate visible} " +

        /* User-defined fields */
        "{order=5 label=Status key=status type=text editable} " +
        "{order=6 label=ID key=id type=text editable} ");

        optlist.Append( "}}");

        p.end_document(optlist.ToString());
    }

    catch (PDFlibException e)
    {
        // caught exception thrown by PDFlib
        Console.WriteLine("PDFlib exception occurred:");
        Console.WriteLine("[{0}] {1}: {2}\n", e.get_errnum(),
                e.get_apiname(), e.get_errmsg());
    } finally {
        if (p != null) {
            p.Dispose();
        }
    }
    return (0);
  }
}
