/*
 * PDFlib client: invoice example in Java
 * Required software: PDFlib+PDI or PDFlib Personalization Server (PPS)
 */

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;

import com.pdflib.pdflib;
import com.pdflib.PDFlibException;

public class invoice {
    final static double x_table = 55;
    final static double tablewidth = 475;

    final static double y_address = 682;
    final static double x_salesrep = 455;
    final static double y_invoice = 542;
    final static double imagesize = 90;

    final static double fontsize = 11;
    final static double fontsizesmall = 9;

    final static String fontname= "NotoSerif-Regular";

    static String basefontoptions;

    /* -----------------------------------
    * Place company stationery as background
    * -----------------------------------
    */
    static void create_stationery(pdflib p) throws Exception
    {
        String sender =
            "Kraxi Systems, Inc. &#x2022; 17, Aviation Road &#x2022; Paperfield";
        String stationeryfontname= "NotoSerif-Regular";

        String stationeryfilename = "kraxi_logo.pdf";

        double y_company_logo = 748;

        String senderfull =
            "17, Aviation Road\n" +
            "Paperfield<nextline leading=50%><nextparagraph leading=120%>" +
            "Phone 7079-4301\n" +
            "Fax 7079-4302<nextline leading=50%><nextparagraph leading=120%>" +
            "info@kraxi.com\n" +
            "www.kraxi.com\n";

        int         page, stationery;
        String      optlist;
        int         tf;

        stationery = p.open_pdi_document(stationeryfilename, "");
        page = p.open_pdi_page(stationery, 1, "");

        p.fit_pdi_page(page, 0, y_company_logo,
                "boxsize={595 85} position={65 center}");
        p.close_pdi_page(page);
        p.close_pdi_document(stationery);

        optlist =  basefontoptions + " fontsize=" + fontsizesmall + 
            " fontname=" + stationeryfontname+ " charref=true";
        p.fit_textline(sender, x_table, y_address + fontsize,
                optlist);

        /* ---------------------------------e
        * Print full company contact details
        * -----------------------------------
        */
        optlist = basefontoptions + " fontname=" + stationeryfontname + 
        " leading=125% fillcolor={cmyk 0.64 0.55 0.52 0.27}";
        tf = p.create_textflow(senderfull, optlist);
        p.fit_textflow(tf, x_salesrep, y_address,
                x_salesrep+imagesize, y_address + 150, "verticalalign=bottom");
        p.delete_textflow(tf);
    }

    /* -----------------------------------
    * Place address and header text
    * -----------------------------------
    */
    static void create_header(pdflib p) throws Exception
    {
        String salesrepfilename = "sales_rep4.jpg";
        String salesrepname = "Lucy Irwin";
        String salesrepcaption = "Local sales rep:";
        String invoiceheader = "INVOICE 2012-03";

        String address =
            "John Q. Doe\n" +
            "255 Customer Lane\n" +
            "Suite B\n" +
            "12345 User Town\n" +
            "Everland";

        String        optlist;
        int           salesrepimage;
        int           tf;

        /* -----------------------------------
        * Print address
        * -----------------------------------
        */
        optlist = basefontoptions + " leading=120%";

        tf = p.create_textflow(address, optlist);
        p.fit_textflow(tf,
                x_table, y_address, x_table+tablewidth/2, y_address-100, "");
        p.delete_textflow(tf);

        /* -----------------------------------
        * Place name and image of local sales rep
        * -----------------------------------
        */
        optlist = basefontoptions + " fontsize=" + fontsizesmall;
        p.fit_textline(salesrepcaption, x_salesrep, y_address-fontsizesmall,
                optlist);
        p.fit_textline(salesrepname, x_salesrep, y_address-2*fontsizesmall,
                optlist);

        salesrepimage = p.load_image("auto", salesrepfilename, "");

        optlist = "boxsize={" + imagesize + " " +  imagesize + "} fitmethod=meet";
        p.fit_image(salesrepimage,
                x_salesrep, y_address-3*fontsizesmall-imagesize, optlist);
        p.close_image(salesrepimage);

        /* -----------------------------------
        * Print the header and date
        * -----------------------------------
        */

        /* Add a bookmark with the header text */
        p.create_bookmark(invoiceheader, "");

        optlist =  basefontoptions;
        p.fit_textline(invoiceheader, x_table, y_invoice, optlist);

        String date = DateFormat.getDateInstance(DateFormat.LONG, Locale.US)
            .format(new Date());

        optlist =  "position {100 0} " + basefontoptions;
        p.fit_textline(date, x_table+tablewidth, y_invoice, optlist);
    }


    public static void main(String argv[]) {
        /* This is where font/image/PDF input files live. Adjust as necessary. */
        String searchpath = "../data";

        /* By default annotations are also imported. In some cases this
         * requires the Noto fonts for creating annotation appearance streams.
         */
    
        String fontpath = "../../resource/font";

        String closingtext =
        "Terms of payment: <fillcolor={rgb 1 0 0}>30 days net. " +
        "<fillcolor={gray 0}>90 days warranty starting at the day of sale. " +
        "This warranty covers defects in workmanship only. " +
        "Kraxi Systems, Inc. will, at its option, repair or replace the " +
        "product under the warranty. This warranty is not transferable. " +
        "No returns or exchanges will be accepted for wet products.";

        class articledata {
            articledata(String name, double price, int quantity) {
                this.name = name;
                this.price = price;
                this.quantity = quantity;
            }

            String name;
            double price;
            int quantity;
        }

        articledata[] dataset = {
        new articledata( "Super Kite",		20,	2),
        new articledata( "Turbo Flyer",	40,	5),
        new articledata( "Giga Trash",		180,	1),
        new articledata( "Bare Bone Kit",	50,	3),
        new articledata( "Nitty Gritty",	20,    10),
        new articledata( "Pretty Dark Flyer",	75,	1),
        new articledata( "Free Gift",		0,	1),
        };

        String[] headers = {
            "ITEM", "DESCRIPTION", "QUANTITY", "PRICE", "AMOUNT"
        };

        String[] alignments = {
            "right", "left", "right", "right", "right"
        };

        final NumberFormat priceFormat = NumberFormat.getInstance(Locale.US);
        priceFormat.setMaximumFractionDigits(2);
        priceFormat.setMinimumFractionDigits(2);

        pdflib p = null;
        try {
            int         i, pagecount=0;
            int         row, col, tbl;
            String      result;
            double      total;
            String      buf;
            int         tf;

            /* create a new PDFlib object */
            p = new pdflib();
            String optlist;

            p.set_option("SearchPath={{" + searchpath + "}}");
            p.set_option("SearchPath={{" + fontpath + "}}");

            /* This mean we don't have to check error return values, but will
            * get an exception in case of runtime problems.
            */
            p.set_option("errorpolicy=exception");

            p.begin_document("invoice.pdf", "");

            p.set_info("Creator", "invoice");
            p.set_info("Author", "Thomas Merz");
            p.set_info("Title", "PDFlib invoice generation demo");

            basefontoptions = "fontname=" + fontname + " fontsize=" + 
                fontsize + "";

            /* -----------------------------------
            * Create and place table with article list
            * -----------------------------------
            */
            /* ---------- Header row */
            row = 1;
            tbl = -1;

            for (col=1; col <= headers.length; col++)
            {
                optlist =  "fittextline={position={" + alignments[col-1] + 
                    " center} " + basefontoptions+ "} margin=2";
                tbl = p.add_table_cell(tbl, col, row, headers[col-1], 
                optlist);
            }
            row++;

            /* ---------- Data rows: one for each article */
            total = 0;

            for (i = 0; i <  dataset.length; i++) {
                double sum = dataset[i].price * dataset[i].quantity;
                col = 1;

                /* column 1: ITEM */
                buf = "" + (i+1);
                optlist = "fittextline={position={" + alignments[col-1] + 
                    " center} " + basefontoptions + "} margin=2";
                tbl = p.add_table_cell(tbl, col++, row, buf, optlist);

                /* column 2: DESCRIPTION */
                optlist = "fittextline={position={"+ alignments[col-1] + 
                    " center} "+ basefontoptions + "} colwidth=50% margin=2";
                tbl = p.add_table_cell(tbl, col++, row, dataset[i].name,
                        optlist);

                /* column 3: QUANTITY */
                buf = "" + dataset[i].quantity;
                optlist = "fittextline={position={" + alignments[col-1] + 
                    " center} "+ basefontoptions + "} margin=2";
                tbl = p.add_table_cell(tbl, col++, row, buf, optlist);

                /* column 4: PRICE */
                buf = priceFormat.format(dataset[i].price);
                optlist = "fittextline={position={" + alignments[col-1] + 
                    " center} " + basefontoptions + "} margin=2";
                tbl = p.add_table_cell(tbl, col++, row, buf, optlist);

                /* column 5: AMOUNT */
                buf = priceFormat.format(sum);
                optlist = "fittextline={position={" + alignments[col - 1] + 
                    " center} " + basefontoptions + " " + "} margin=2";
                tbl = p.add_table_cell(tbl, col++, row, buf, optlist);

                total += sum;
                row++;
            }

            /* ---------- Print total in the rightmost column */
            buf = priceFormat.format(total);
            optlist = "fittextline={position={" +
                alignments[headers.length - 1] + " center} " +
                basefontoptions + "} margin=2";
            tbl = p.add_table_cell(tbl, headers.length, row++, buf, optlist);


            /* ---------- Footer row with terms of payment */
            optlist = basefontoptions + " alignment=justify leading=120%";
            tf = p.create_textflow(closingtext, optlist);

            optlist = "rowheight=1 margin=2 margintop=" + 2*fontsize + 
                " textflow=" + tf + " colspan= " + headers.length;
            tbl = p.add_table_cell(tbl, 1, row++, "", optlist);


            /* ---------- Place the table instance(s), creating pages as required */
            do {
                double top;

                p.begin_page_ext(0, 0, "width=a4.width height=a4.height");

                if (++pagecount == 1)
                {
                    create_stationery(p);
                    create_header(p);
                    top = y_invoice - 3*fontsize;
                }
                else
                {
                    top = 50;
                }

                /* Place the table on the page; Shade every other row. */
                optlist =  "header=1 fill={{area=rowodd fillcolor={gray 0.9}}} ";

                result = p.fit_table(tbl,
                        x_table, top, x_table+tablewidth, 20, optlist);

                if (result.equals("_error")) {
                    throw new Exception("Couldn't place table: "
                        + p.get_errmsg());
                }

                p.end_page_ext("");
            } while (result.equals("_boxfull"));

            p.delete_table(tbl, "");

            p.end_document("");
        }
        catch (PDFlibException e) {
            System.err.println("PDFlib exception occurred in invoice sample:");
            System.err.println("[" + e.get_errnum() + "] " + e.get_apiname()
                    + ": " + e.get_errmsg());
        }
        catch (Exception e) {
            System.err.println(e);
        }
        finally {
            if (p != null) {
                p.delete();
            }
        }
    }
}
