/* 
 * pCOS starter:
 * Dump information from an existing PDF document
 *
 * Required software: PDFlib+PDI or PDFlib Personalization Server (PPS)
 * Required data: PDF input file
 */
import java.io.UnsupportedEncodingException;
import com.pdflib.pdflib;
import com.pdflib.PDFlibException;
import java.text.DecimalFormat;
import java.util.Locale;

public class starter_pcos {
    public static void main(String argv[]) {
	Locale.setDefault(Locale.US);
        /* This is where the data files are. Adjust as necessary. */
        String searchpath = "../data";

        pdflib p = null;
        String pdfinput = "pCOS-datasheet.pdf";

        final String docoptlist = "requiredmode=minimum";
    
        try {
            int count;
            String pcosmode;
            int i;
            boolean plainmetadata;
            String objtype;
    
            p = new pdflib();

            /*
             * This means we must check return values of load_font() etc.
             * Set the search path for fonts and images etc.
             */
            p.set_option("errorpolicy=return SearchPath={{" + searchpath + "}}");
           
            /* Open the PDF document */
            int doc = p.open_pdi_document(pdfinput, docoptlist);
            if (doc == -1)
                throw new Exception("Error: " + p.get_errmsg());
            
            /* --------- general information (always available) */
    
            pcosmode = p.pcos_get_string(doc, "pcosmodename");
    
            System.out.println("   File name: " + p.pcos_get_string(doc, "filename"));
    
            System.out.println(" PDF version: "
                + p.pcos_get_string(doc, "pdfversionstring"));
    
            System.out.println("  Encryption: "
                + p.pcos_get_string(doc, "encrypt/description"));
    
            System.out.println("   Master pw: "
                + ((p.pcos_get_number(doc, "encrypt/master") != 0) ? "yes" : "no"));
    
            System.out.println("     User pw: "
                + ((p.pcos_get_number(doc, "encrypt/user") != 0) ? "yes" : "no"));
    
            System.out.println("Text copying: "
                + ((p.pcos_get_number(doc, "encrypt/nocopy") != 0) ? "no" : "yes"));
    
            System.out.println("  Linearized: "
                + ((p.pcos_get_number(doc, "linearized") != 0) ? "yes" : "no"));
    
            System.out.println();
            
            if (pcosmode.equals("minimum")) {
                System.out.println("Minimum mode: no more information available\n");
                p.delete();
                System.exit(0);
            }
    
            /* --------- more details (requires at least user password) */
    
            System.out.println("PDF/X status: " + p.pcos_get_string(doc, "pdfx"));
    
            System.out.println("PDF/A status: " + p.pcos_get_string(doc, "pdfa"));
    
            boolean xfa_present =
                !p.pcos_get_string(doc, "type:/Root/AcroForm/XFA").equals("null");
            System.out.println("    XFA data: " + (xfa_present ? "yes" : "no"));
            
            System.out.println("  Tagged PDF: "
                + ((p.pcos_get_number(doc, "tagged") != 0) ? "yes" : "no"));
    
            System.out.println("No. of pages: "
                + (int) p.pcos_get_number(doc, "length:pages"));
            
            DecimalFormat page_dim_format = new DecimalFormat();
            page_dim_format.setMinimumFractionDigits(3);
            page_dim_format.setMaximumFractionDigits(3);
    
            System.out.println(" Page 1 size: width="
                    + page_dim_format.format(p.pcos_get_number(doc,
                            "pages[0]/width"))
                    + ", height="
                    + page_dim_format.format(p.pcos_get_number(doc,
                            "pages[0]/height")));
    
            count = (int) p.pcos_get_number(doc, "length:fonts");
            System.out.println("No. of fonts: " + count);
    
            for (i = 0; i < count; i++) {
                String fonts;
    
                fonts = "fonts[" + i + "]/embedded";
                if (p.pcos_get_number(doc, fonts) != 0)
                    System.out.print("embedded ");
                else
                    System.out.print("unembedded ");
    
                fonts = "fonts[" + i + "]/type";
                System.out.print(p.pcos_get_string(doc, fonts) + " font ");
                fonts = "fonts[" + i + "]/name";
                System.out.println(p.pcos_get_string(doc, fonts));
            }
    
            System.out.println();
    
            plainmetadata = p.pcos_get_number(doc, "encrypt/plainmetadata") != 0;
    
            if (pcosmode.equals("restricted") && !plainmetadata
                && p.pcos_get_number(doc, "encrypt/nocopy") != 0) {
                System.out.print("Restricted mode: no more information available");
                p.delete();
                System.exit(0);
            }
    
            /* ----- document info keys and XMP metadata (requires master pw) */
    
            count = (int) p.pcos_get_number(doc, "length:/Info");
    
            for (i = 0; i < count; i++) {
                String info;
                String key;
                int len;
    
                info = "type:/Info[" + i + "]";
                objtype = p.pcos_get_string(doc, info);
    
                info = "/Info[" + i + "].key";
                key = p.pcos_get_string(doc, info);
                len = 12 - key.length();
                while (len-- > 0)
                    System.out.print(" ");
    
                System.out.print(key + ": ");
    
                /* Info entries can be stored as string or name objects */
                if (objtype.equals("name") || objtype.equals("string")) {
                    info = "/Info[" + i + "]";
                    System.out.println("'" + p.pcos_get_string(doc, info) + "'");
                }
                else {
                    info = "type:/Info[" + i + "]";
                    System.out.println("(" + p.pcos_get_string(doc, info) + " object)");
                }
            }
    
            System.out.println();
            System.out.print("XMP metadata: ");
    
            objtype = p.pcos_get_string(doc, "type:/Root/Metadata");
            if (objtype.equals("stream")) {
                byte[] contents;
    
                contents = p.pcos_get_stream(doc, "", "/Root/Metadata");

                /* This demonstrates Unicode conversion */
                String string = p.convert_to_unicode("utf8", contents, 
                                "outputformat=utf16");
                System.out.print("(" + (string.length()) + " Unicode code points)");
                System.out.println("");
            }
            else {
                System.out.println("not present");
            }
            
            p.close_pdi_document(doc);
        }
        catch (PDFlibException e) {
            System.err.println("PDFlib exception occurred:");
            System.err.println("[" + e.get_errnum() + "] " + e.get_apiname()
                    + ": " + e.get_errmsg());
        }
        catch (Exception e) {
            System.err.println(e);
        }
        finally {
            if (p != null) {
                p.delete();
            }
        }
    }
}
