/* 
 * PDF/A-1b starter:
 * Create PDF/A-1b conforming output
 *
 * Required data: font file, image file
 */

import com.pdflib.pdflib;
import com.pdflib.PDFlibException;

public class starter_pdfa1b {
    public static void main(String argv[]) {
        /* This is where the data files are. Adjust as necessary. */
        String searchpath = "../data";

        pdflib p = null;
        String imagefile = "nesrin.jpg";

        int image;

        try {
            p = new pdflib();

            /*
             * This means we must check return values of load_font() etc.
             * Set the search path for fonts and images etc.
             */
            p.set_option("errorpolicy=return SearchPath={{" + searchpath + "}}");

            /* PDF/A-1a requires Tagged PDF */
            if (p.begin_document("starter_pdfa1b.pdf", "pdfa=PDF/A-1b:2005") == -1)
                throw new Exception("Error: " + p.get_errmsg());

            p.set_info("Creator", "PDFlib starter sample");
            p.set_info("Title", "starter_pdfa1b");

            p.begin_page_ext(0,0, "width=a4.width height=a4.height");

            p.fit_textline("PDF/A-1b:2005 starter", 50, 700, 
                "fontname=NotoSerif-Regular fontsize=24");

            /* Load an RGB image */
            image = p.load_image("auto", imagefile, "");

            if (image == -1)
                throw new Exception("Error: " + p.get_errmsg());

            /* Place the image at the bottom of the page */
            p.fit_image(image, 0.0, 0.0, "scale=0.5");

            p.end_page_ext("");
            p.close_image(image);

            p.end_document("");

        }
        catch (PDFlibException e) {
            System.err.println("PDFlib exception occurred:");
            System.err.println("[" + e.get_errnum() + "] " + e.get_apiname()
                    + ": " + e.get_errmsg());
        }
        catch (Exception e) {
            System.err.println(e);
        }
        finally {
            if (p != null) {
                p.delete();
            }
        }
    }
}
