/* 
 * PDF merge starter:
 * Merge pages from multiple PDF documents (including annotations)
 *
 * Required software: PDFlib+PDI or PDFlib Personalization Server (PPS)
 * Required data: PDF documents
 */

import com.pdflib.pdflib;
import com.pdflib.PDFlibException;

public class starter_pdfmerge {
    public static void main(String argv[]) {
        /* This is where the data files are. Adjust as necessary. */
        String searchpath = "../data";
        /* By default annotations are also imported. In some cases this
         * requires the Noto fonts for creating annotation appearance streams.
         */
    
        String fontpath = "../../resource/font";

        pdflib p = null;
        String pdffiles[] = {  
            "markup_annotations.pdf",
            "pCOS-datasheet.pdf" };
        int i;

        try {
            p = new pdflib();
            /*
             * This means we must check return values of load_font() etc.
             * Set the search path for fonts and images etc.
             */
            p.set_option("errorpolicy=return SearchPath={{" + searchpath + "}}");
            p.set_option("SearchPath={{" + fontpath + "}}");

            if (p.begin_document("starter_pdfmerge.pdf", "") == -1)
                throw new Exception("Error: " + p.get_errmsg());

            p.set_info("Creator", "PDFlib starter sample");
            p.set_info("Title", "starter_pdfmerge");

            for (i = 0; i < pdffiles.length; i++) {
                int indoc, endpage, pageno, page;

                /* Open the input PDF */
                indoc = p.open_pdi_document(pdffiles[i], "");
                if (indoc == -1) {
                    System.err.println("Error: " + p.get_errmsg());
                    continue;
                }

                endpage = (int) p.pcos_get_number(indoc, "length:pages");

                /* Loop over all pages of the input document */
                for (pageno = 1; pageno <= endpage; pageno++) {
                    page = p.open_pdi_page(indoc, pageno, "");

                    if (page == -1) {
                        System.err.println("Error: " + p.get_errmsg());
                        continue;
                    }
                    /* Dummy page size; will be adjusted later */
                    p.begin_page_ext(10, 10, "");

                    /* Create a bookmark with the file name */
                    if (pageno == 1)
                        p.create_bookmark(pdffiles[i], "");

                    /*
                     * Place the imported page on the output page, and adjust
                     * the page size. If the page contains annotations
                     * these are also imported.
                     */
                    p.fit_pdi_page(page, 0, 0, "adjustpage");
                    p.close_pdi_page(page);

                    p.end_page_ext("");
                }
                p.close_pdi_document(indoc);
            }

            p.end_document("");

        }
        catch (PDFlibException e) {
            System.err.println("PDFlib exception occurred:");
            System.err.println("[" + e.get_errnum() + "] " + e.get_apiname()
                    + ": " + e.get_errmsg());
        }
        catch (Exception e) {
            System.err.println(e);
        }
        finally {
            if (p != null) {
                p.delete();
            }
        }
    }
}
