/* 
 * Starter SVG:
 * Load SVG graphics and fit into a box
 *
 * Required data: SVG graphics
 */

import com.pdflib.pdflib;
import com.pdflib.PDFlibException;

public class starter_svg {
    public static void main(String argv[]) {
    /* This is where the data files are. Adjust as necessary. */
    String searchpath = "../data";
    String outfile = "starter_svg.pdf";

    pdflib p = null;
    String graphicsfile = "PDFlib-logo.svg";
    int graphics;
    int x = 100, y = 300;
    int boxwidth = 400, boxheight = 400;
    String optlist;

    try {
        p = new pdflib();

        p.set_option("SearchPath={{" + searchpath + "}}");

        /* This means we must check return values of load_graphics() etc. */
        p.set_option("errorpolicy=return");

        if (p.begin_document(outfile, "") == -1)
        throw new Exception("Error: " + p.get_errmsg());

        p.set_info("Creator", "PDFlib starter sample");
        p.set_info("Title", "starter_svg");

        /* Load the graphics */
        graphics = p.load_graphics("auto", graphicsfile, "");
        if (graphics == -1)
        throw new Exception("Error: " + p.get_errmsg());

        p.begin_page_ext(0, 0, "width=a4.width height=a4.height");

        /* ------------------------------------------------------
         * Fit the graphics into a box with proportional resizing
         * ------------------------------------------------------
         */

        /* The "boxsize" option defines a box with a given width and height 
         * and its lower left corner located at the reference point.
         * "position={center}" positions the graphics in the center of the
         * box.
         * "fitmethod=meet" resizes the graphics proportionally until its 
         * height or width completely fits into the box.
         * The "showborder" option is used to illustrate the borders of the 
         * box 
         */
        optlist = "boxsize={ " + boxwidth + " " + boxheight + 
              "} position={center} fitmethod=meet showborder";

        /* Before actually fitting the graphics we check whether fitting is
         * possible.
         */
        if (p.info_graphics(graphics, "fittingpossible", optlist) == 1)
        {
            p.fit_graphics(graphics, x, y, optlist);
        }
        else
        {
            System.err.println("Cannot place graphics: " + p.get_errmsg());
        }

        p.end_page_ext("");

        p.close_graphics(graphics);

        p.end_document("");
    }
    catch (PDFlibException e) {
        System.err.println("PDFlib exception occurred:");
        System.err.println("[" + e.get_errnum() + "] " + e.get_apiname()
            + ": " + e.get_errmsg());
    }
    catch (Exception e) {
        System.err.println(e);
    }
    finally {
        if (p != null) {
        p.delete();
        }
    }
    }	


}
