#!/usr/bin/perl
#
# PDFlib client: fill Blocks with PPS to create a business card
# Required software: PDFlib Personalization Server (PPS)
#

use PDFlib::PDFlib;
use strict;

my $infile = "boilerplate.pdf";
# This is where font/image/PDF input files live. Adjust as necessary.
# Note that this directory must also contain the font files.
#
my $searchpath = "../data";

# By default annotations are also imported. In some cases this
# requires the Noto fonts for creating annotation appearance streams.
#
my $fontpath = "../../resource/font";

my @dataset = (   
        ["name",                     "Victor Kraxi"], 
        ["business.title",           "Chief Paper Officer"],
        ["business.address.line1",   "17, Aviation Road"],
        ["business.address.city",    "Paperfield"],
        ["business.telephone.voice", "phone +1 234 567-89"],
        ["business.telephone.fax",   "fax +1 234 567-98"],
        ["business.email",           "victor\@kraxi.com"],
        ["business.homepage",        "www.kraxi.com"]
    );

eval {
    my $p = new PDFlib::PDFlib;

    # This means we must check return values of load_font() etc.
    # Set the search path for fonts and PDF files
    $p->set_option("errorpolicy=return SearchPath={{" . $searchpath ."}}");
    $p->set_option("SearchPath={{" . $fontpath ."}}");

    if ($p->begin_document("businesscard.pdf", "") == -1){
        die ("Error: %s\n", $p->get_errmsg());
    }

    $p->set_info("Creator", "businesscard");
    $p->set_info("Author", "Thomas Merz");
    $p->set_info("Title", "PDFlib Block processing sample");

    my $blockcontainer = $p->open_pdi_document($infile, "");
    if ($blockcontainer == -1){
        die ("Error: %s\n", $p->get_errmsg());
    }

    # Loop over all pages of the input document 
    my $pagecount = $p->pcos_get_number($blockcontainer, "length:pages");
    for (my $pageno = 1; $pageno <= $pagecount; $pageno++){

        my $page = $p->open_pdi_page($blockcontainer, $pageno, "");
        if ($page == -1){
            die ("Error: %s\n", $p->get_errmsg());
        }

        $p->begin_page_ext(20, 20, "");		# dummy page size

        # This will adjust the page size to the size of the input page
        $p->fit_pdi_page($page, 0, 0, "adjustpage");

        # Fill all text Blocks with dynamic data
        for (my $i = 0; $i <=  $#dataset; $i++) {
            if ($p->fill_textblock($page, $dataset[$i][0], $dataset[$i][1],
                    "") == -1) {
                printf ("Warning: %s\n", $p->get_errmsg());
            }
        }

        $p->end_page_ext("");
        $p->close_pdi_page($page);

    }

    $p->end_document("");
    $p->close_pdi_document($blockcontainer);
};

if ($@) {
    die("$0: PDFlib Exception occurred:\n$@");
}
