#!/usr/bin/perl
#
# PDFlib client: image example in Perl
#

use PDFlib::PDFlib;
use strict;

# This is where font/image/PDF input files live. Adjust as necessary.
my $searchpath = "../data";
my $imagefile = "nesrin.jpg";

my $p = new PDFlib::PDFlib;

eval {
    # This means we must check return values of load_image() etc.
    $p->set_option("errorpolicy=return");

    $p->set_option("SearchPath={{" . $searchpath ."}}");

    if ($p->begin_document("image.pdf", "") == -1){
        die("Error: %s\n", $p->get_errmsg());
    }

    $p->set_info("Creator", "image");
    $p->set_info("Author", "Thomas Merz");
    $p->set_info("Title", "image sample");

    my $image = $p->load_image("auto", $imagefile, "");
    die "Couldn't open image '$imagefile'" if ($image == -1);

    # dummy page size, will be adjusted by $p->fit_image()
    $p->begin_page_ext(0, 0, "width=a4.width height=a4.height");
    $p->fit_image($image, 0, 0, "adjustpage");
    $p->close_image($image);
    $p->end_page_ext("");

    $p->end_document("");
};

if ($@) {
    die("$0: PDFlib Exception occurred:\n$@");
}
