#!/usr/bin/perl
#
# formfields starter:
# create a linearized PDF (for fast delivery over the Web, also known
# as "fast Web view") which is encrypted and contains some form fields.
# A few lines of JavaScript are inserted as "page open" action to
# automatically populate the date field with the current date.
#
# Required data: font file

use PDFlib::PDFlib;
use strict;

# This is where the data files are. Adjust as necessary.
my $searchpath = "../data";

my $outfilename = "starter_formfields.pdf";

my $llx=150; my $lly=550; my $urx=350; my $ury=575;

# JavaScript for automatically filling the date into a form field
my $js = "var d = util.printd(\"mm/dd/yyyy\", new Date());" .
    "var date = this.getField(\"date\");" .
    "date.value = d;";

my $p = new PDFlib::PDFlib;

eval {
    # This means we must check return values of load_font() etc.
    $p->set_option("errorpolicy=return searchpath={{" . $searchpath . "}}");

    # Prevent changes with a master password
    my $optlist = "linearize masterpassword=pdflib permissions={nomodify}";

    if ($p->begin_document($outfilename, $optlist) == -1) {
        die("Error: " . $p->get_errmsg());
    }

    $p->set_info("Creator", "PDFlib starter sample");
    $p->set_info("Title", "starter_formfields");

    $optlist = "script[" . length($js) . "]={" . $js . "}";
    my $action = $p->create_action("JavaScript", $optlist);

    $optlist = "width=a4.width height=a4.height action={open=" . $action . "}";
    $p->begin_page_ext(0, 0, $optlist);

    my $font = $p->load_font("NotoSerif-Regular", "winansi", "simplefont nosubsetting");
    if ($font == -1) {
        die("Error: %s\n", $p->get_errmsg());
    }

    $p->setfont($font, 24);

    $p->fit_textline("Date: ", 125, $lly+5, "position={right bottom}");

    # The tooltip will be used as rollover text for the field
    $optlist =
        "tooltip={Date (will be filled automatically)} " .
        "bordercolor={gray 0} font=" . $font;
    $p->create_field($llx, $lly, $urx, $ury, "date", "textfield", $optlist);

    $lly-=100; $ury-=100;
    $p->fit_textline("Name: ", 125, $lly+5, "position={right bottom}");

    $optlist = "tooltip={Enter your name here} " .
        "bordercolor={gray 0} font=" . $font;
    $p->create_field($llx, $lly, $urx, $ury, "name", "textfield", $optlist);

    $p->end_page_ext("");

    $p->end_document("");

};

if ($@) {
    die("$0: PDFlib Exception occurred:\n$@");
}
