#!/usr/bin/perl
# 
# Starter SVG:
# Load SVG graphics and fit into a box
#
# Required data: SVG graphics

use PDFlib::PDFlib;
use strict;

my $searchpath = "../data";
my $outfile = "starter_svg.pdf";

my $graphicsfile = "PDFlib-logo.svg";
my $x = 100; 
my $y = 300;
my $boxwidth = 400; 
my $boxheight = 400;
my $optlist;
my $graphics;

eval {
    my $p = new PDFlib::PDFlib;

    $p->set_option("SearchPath={{" . $searchpath . "}}");

    # This means we must check return values of load_graphics() etc. 
    $p->set_option("errorpolicy=return");

    if ($p->begin_document($outfile, "") == -1){
        printf("Error: %s\n", $p->get_errmsg()); exit;
    }

    $p->set_info("Creator", "PDFlib starter sample");
    $p->set_info("Title", "starter_svg");

    # Load the graphics 
    $graphics = $p->load_graphics("auto", $graphicsfile, "");
    if ($graphics == -1){
        printf("Error: %s\n", $p->get_errmsg()); exit;
    }

    $p->begin_page_ext(0, 0, "width=a4.width height=a4.height");

    # ------------------------------------------------------
    # Fit the graphics into a box with proportional resizing
    # ------------------------------------------------------

    # The "boxsize" option defines a box with a given width and height 
    # and its lower left corner located at the reference point.
    # "position={center}" positions the graphics in the center of the
    # box.
    # "fitmethod=meet" resizes the graphics proportionally until its 
    # height or width completely fits into the box.
    # The "showborder" option is used to illustrate the borders of the 
    # box 

    $optlist = "boxsize={ " . $boxwidth . " " . $boxheight . 
            "} position={center} fitmethod=meet showborder";

    # Before actually fitting the graphics we check whether fitting is
    # possible.

    if ($p->info_graphics($graphics, "fittingpossible", $optlist) == 1)
    {
        $p->fit_graphics($graphics, $x, $y, $optlist);
    }
    else
    {
        printf("Cannot place graphics: %s\n" , $p->get_errmsg());
    }

    $p->end_page_ext("");

    $p->close_graphics($graphics);


    $p->end_document("");

};
if ($@) {
    die("$0: PDFlib Exception occurred:\n$@");
}

