#!/usr/bin/env ruby
#
# PDFlib client: hello example in Ruby
#

require 'PDFlib'

begin
  searchpath = "../data"
  p = PDFlib.new

  # This means we must check return values of load_font() etc.
  p.set_option("errorpolicy=return")

  # This means we must check return values of load_font() etc.
  p.set_option("SearchPath={{" + searchpath + "}}")

  if (p.begin_document("hello.pdf", "") == -1)
    raise  "Error: " + p.get_errmsg
  end

  p.set_info("Creator", "hello.rb")
  p.set_info("Author", "Thomas Merz")
  p.set_info("Title", "Hello world (Ruby)!")

  p.begin_page_ext(0,0, "width=a4.width height=a4.height")

  fontopt = "fontname=NotoSerif-Regular fontsize=24";

  p.fit_textline("Hello world!", 50, 700, fontopt);
  p.fit_textline("(says Ruby)",  50, 676, fontopt);

  p.end_page_ext("")

  p.end_document("")

rescue  PDFlibException => pe
  print "PDFlib exception occurred in hello sample:\n"
  print "[" + pe.get_errnum.to_s + "] " + pe.get_apiname + \
		  ": " + pe.get_errmsg + "\n"
rescue  Exception => e
  print e.backtrace.join("\n") + "\n" + e.to_s
ensure
  p.delete() if p
end

# vim: sw=2
