#!/usr/bin/env ruby
#
# PDF/A-1b starter:
# Create PDF/A-1b conforming output
#
# Required data: font file, image file
#/

require 'PDFlib'


searchpath = "../data"

imagefile = "nesrin.jpg"

begin
  p = PDFlib.new

  # This means we must check return values of load_font() etc.
  p.set_option("errorpolicy=return")

  p.set_option("SearchPath={{" + searchpath +"}}")

  # PDF/A-1a requires Tagged PDF
  if (p.begin_document("starter_pdfa1b.pdf", "pdfa=PDF/A-1b:2005") == -1)
    raise "Error: " + p.get_errmsg()
  end

  p.set_info("Creator", "PDFlib starter sample")
  p.set_info("Title", "starter_pdfa1b")

  p.begin_page_ext(0,0, "width=a4.width height=a4.height")

  p.fit_textline("PDF/A-1b:2005 starter", 50, 700, 
    "fontname=NotoSerif-Regular fontsize=24")

  # Load an RGB image
  image = p.load_image("auto", imagefile, "")

  if (image == -1)
    raise "Error: " + p.get_errmsg()
  end

  # Place the image at the bottom of the page
  p.fit_image(image, 0.0, 0.0, "scale=0.5")

  p.end_page_ext("")
  p.close_image(image)

  p.end_document("")

rescue  PDFlibException => pe
  print "PDFlib exception occurred:\n"
  print "[" + pe.get_errnum.to_s + "] " + pe.get_apiname + \
		": " + pe.get_errmsg + "\n"
rescue  Exception => e
  print e.backtrace.join("\n") + "\n" + e.to_s
ensure
  p.delete() if p
end

# vim: sw=2
