#!/usr/bin/env ruby
#
# PDF/X-3 starter:
# Create PDF/X-3 conforming output
#
# Required data: font file, image file, ICC profile
#                (see www.pdflib.com for output intent ICC profiles)
#/

require 'PDFlib'

# This is where the data files are. Adjust as necessary
String searchpath = "../data"

String imagefile = "nesrin.jpg"

begin
  p = PDFlib.new

  # This means we must check return values of load_font() etc.
  p.set_option("errorpolicy=return")

  p.set_option("SearchPath={{" + searchpath +"}}")

  if (p.begin_document("starter_pdfx3.pdf", "pdfx=PDF/X-3:2003") == -1)
    raise "Error: " + p.get_errmsg()
  end

  p.set_info("Creator", "PDFlib starter sample")
  p.set_info("Title", "starter_pdfx3")

  if (p.load_iccprofile("ISOcoated_v2_eci.icc", "usage=outputintent") == -1)
      raise "Error: " +  p.get_errmsg() + "\n" \
	+ "See www.pdflib.com for output intent ICC profiles.\n"
  end

  p.begin_page_ext(0,0, "width=a4.width height=a4.height")

  font = p.load_font("NotoSerif-Regular", "unicode", "")

  if font == -1
    raise "Error: " + p.get_errmsg + "\n"
  end

  p.setfont(font, 24)

  spot = p.makespotcolor("PANTONE 123 C")
  p.setcolor("fill", "spot", spot, 1.0, 0.0, 0.0)
  p.fit_textline("PDF/X-3:2003 starter", 50, 700, "")

  image = p.load_image("auto", imagefile, "")

  if (image == -1)
    raise "Error: " + p.get_errmsg()
  end

  p.fit_image(image, 0.0, 0.0, "scale=0.5")

  p.end_page_ext("")

  p.end_document("")

rescue  PDFlibException => pe
  print "PDFlib exception occurred:\n"
  print "[" + pe.get_errnum.to_s + "] " + pe.get_apiname + \
		": " + pe.get_errmsg + "\n"
rescue  Exception => e
  print e.backtrace.join("\n") + "\n" + e.to_s
ensure
  p.delete() if p
end

# vim: sw=2
