/* 
 * PDFlib client: fill Blocks with PPS to create a business card
 * Required software: PDFlib Personalization Server (PPS)
 */

import com.pdflib.pdflib;
import com.pdflib.PDFlibException;

public class businesscard {
    public static void main(String argv[]) {
        pdflib p = null;
        int i, blockcontainer, page;
        String infile = "boilerplate.pdf";
        /*
         * This is where font/image/PDF input files live. Adjust as necessary.
         * Note that this directory must also contain the font files
         */
        String searchpath = "../data";

        /* By default annotations are also imported. In some cases this
         * requires the Noto fonts for creating annotation appearance streams.
         */
    
        String fontpath = "../../resource/font";

        String[][] dataset = {
            { "name",                           "Victor Kraxi" },
            { "business.title",                 "Chief Paper Officer" },
            { "business.address.line1",         "17, Aviation Road" },
            { "business.address.city",          "Paperfield" },
            { "business.telephone.voice",       "phone +1 234 567-89" },
            { "business.telephone.fax",         "fax +1 234 567-98" },
            { "business.email",                 "victor@kraxi.com" },
            { "business.homepage",              "www.kraxi.com" }, };

        try {
            p = new pdflib();

            /* 
             * This means we must check return values of load_font() etc.
             * Set the search path for fonts and PDF files 
	     */
            p.set_option("errorpolicy=return SearchPath={{" + searchpath + "}}");

            p.set_option("SearchPath={{" + fontpath + "}}");


            if (p.begin_document("businesscard.pdf", "") == -1) {
                throw new Exception("Error: " + p.get_errmsg());
            }

            p.set_info("Creator", "businesscard");
            p.set_info("Author", "Thomas Merz");
            p.set_info("Title", "PDFlib Block processing sample");

            blockcontainer = p.open_pdi_document(infile, "");
            if (blockcontainer == -1) {
                throw new Exception("Error: " + p.get_errmsg());
            }

            /* Loop over all pages of the input document */
            int pagecount = (int) p.pcos_get_number(blockcontainer, "length:pages");
            for (int pageno = 1; pageno <= pagecount; pageno++)
            {
                page = p.open_pdi_page(blockcontainer, pageno, "");
                if (page == -1) {
                    throw new Exception("Error: " + p.get_errmsg());
                }
    
                p.begin_page_ext(20, 20, "");           // dummy page size
    
                // This will adjust the page size to the size of the input page
                p.fit_pdi_page(page, 0, 0, "adjustpage");
    
                // Fill all text Blocks with dynamic data
                for (i = 0; i < (int) dataset.length; i++) {
                    if (p.fill_textblock(page, dataset[i][0], dataset[i][1],
                            "") == -1) {
                        System.err.println("Warning: " + p.get_errmsg());
                    }
                }
    
                p.end_page_ext("");
                p.close_pdi_page(page);
            }

            p.end_document("");
            p.close_pdi_document(blockcontainer);

        }
        catch (PDFlibException e) {
            System.err
		.println("PDFlib exception occurred in businesscard sample:");
            System.err.println("[" + e.get_errnum() + "] " + e.get_apiname()
                    + ": " + e.get_errmsg());
        }
        catch (Exception e) {
            System.err.println(e);
        }
        finally {
            if (p != null) {
                p.delete();
            }
        }
    }
}
