/* 
 * PDFlib client: hello example in Java
 */

import com.pdflib.pdflib;
import com.pdflib.PDFlibException;

public class hello {
    public static void main(String argv[]) {
        final String searchpath = "../data";
        pdflib p = null;

        try {
            p = new pdflib();

            /* This means we must check return values of load_font() etc. */
            p.set_option("errorpolicy=return");
            
            /* Set the search path for font files */
            p.set_option("SearchPath={{" + searchpath +"}}");

            if (p.begin_document("hello.pdf", "") == -1)
                throw new Exception("Error: " + p.get_errmsg());

            p.set_info("Creator", "hello.java");
            p.set_info("Author", "Thomas Merz");
            p.set_info("Title", "Hello world (Java)!");

            p.begin_page_ext(0, 0, "width=a4.width height=a4.height");

            String fontopt =
                "fontname=NotoSerif-Regular fontsize=24";

            p.fit_textline("Hello world!", 50, 700, fontopt);
            p.fit_textline("(says Java)",  50, 676, fontopt);

            p.end_page_ext("");

            p.end_document("");
        }
        catch (PDFlibException e) {
            System.err.println("PDFlib exception occurred in hello sample:");
            System.err.println("[" + e.get_errnum() + "] " + e.get_apiname()
                    + ": " + e.get_errmsg());
        }
        catch (Exception e) {
            System.err.println(e);
        }
        finally {
            if (p != null) {
                p.delete();
            }
        }
    }
}
