/* 
 * PDFlib client: image example in Java
 */

import com.pdflib.pdflib;
import com.pdflib.PDFlibException;

public class image {
    public static void main(String argv[]) {
        int image;
        pdflib p = null;
        String imagefile = "nesrin.jpg";
        /* This is where font/image/PDF input files live. Adjust as necessary. */
        String searchpath = "../data";

        try {

            p = new pdflib();

            /*
             * This means we must check return values of load_image() etc.
             * Set the search path for fonts and PDF files
             */
            p.set_option("errorpolicy=return SearchPath={{" + searchpath + "}}");

            if (p.begin_document("image.pdf", "") == -1)
                throw new Exception("Error: " + p.get_errmsg());


            p.set_info("Creator", "image");
            p.set_info("Author", "Thomas Merz");
            p.set_info("Title", "image sample");

            image = p.load_image("auto", imagefile, "");

            if (image == -1)
                throw new Exception("Error: " + p.get_errmsg());

            /* dummy page size, will be adjusted by PDF_fit_image() */
            p.begin_page_ext(0, 0, "width=a4.width height=a4.height");
            p.fit_image(image, 0.0, 0.0, "adjustpage");
            p.close_image(image);
            p.end_page_ext("");

            p.end_document("");
        }
        catch (PDFlibException e) {
            System.err.println("PDFlib exception occurred in image sample:");
            System.err.println("[" + e.get_errnum() + "] " + e.get_apiname()
                    + ": " + e.get_errmsg());
        }
        catch (Exception e) {
            System.err.println(e);
        }
        finally {
            if (p != null) {
                p.delete();
            }
        }
    }
}
