/*---------------------------------------------------------------------------*
 |          Copyright (c) 2002-2022 PDFlib GmbH. All rights reserved.        |
 +---------------------------------------------------------------------------+
 |    This software may not be copied or distributed except as expressly     |
 |    authorized by PDFlib GmbH's general license agreement or a custom      |
 |    license agreement signed by PDFlib GmbH.                               |
 |    For more information about licensing please refer to www.pdflib.com.   |
 *---------------------------------------------------------------------------*/

/*
 * PDFlibException Java class
 */

package com.pdflib;

/** Exception handling for PDFlib.

    @author PDFlib GmbH
    @version 11.0.0
*/

public class PDFlibException extends Exception {
    /** PDFlibException()
     */
    public PDFlibException() {
        super();
    }

    /** PDFlibException(String msg)
     * @param msg msg
     */
    public PDFlibException(String msg) {
        super(msg);
    }

    /** PDFlibException(String msg, int errnum, String apiname)
     * @param msg msg
     * @param errnum errnum
     * @param apiname apiname
     */
    public PDFlibException(String msg, int errnum, String apiname) {
        super(msg);
        pdflib_errnum = errnum;
        pdflib_apiname = apiname;
    }

    /** Map standard getMessage method to get_errmsg.
     * 
     * @return  A string describing the error, or an empty string if the
     *          last API call didn't cause any error. 
     */
    public String get_errmsg() {
        return super.getMessage();
    }

    /** Get the error number of the exception.
     * @return  The exception's error number. 
     */
    public int get_errnum() {
        return pdflib_errnum;
    }

    /** Get the name of the API function which caused the exception.
     * @return  The name of an API function. 
     */
    public String get_apiname() {
        return pdflib_apiname;
    }

    /** private pdflib_errnum
     */
    private int pdflib_errnum;
    /** private pdflib_apiname
     */
    private String pdflib_apiname;
}
