     H DEBUG(*YES) DFTACTGRP(*NO) ACTGRP(*NEW) BNDDIR('TETLIB/TETLIB')
     H COPYRIGHT('(c) PDFlib GmbH (www.pdflib.com)')
      *********************************************************************************************
      *   TET sample application for dumping PDF information with pCOS
      *
      *   Note: All strings passed into PDFlib are unicode strings with varying length.
      *         Use the %UCS2 build in function to convert a single byte string into a unicode string.
      *         All strings returned from PDFlib are unicode strings with varying length.
      *         Use the %CHAR build in function to convert a unicode string to a single byte string.
      *********************************************************************************************
     d/copy QRPGLESRC,TETLIB
     d/copy QRPGLESRC,IFSIO
      *********************************************************************************************
     d tet             s               *
     d count           s             10i 0
     d pcosmode        s             50    based(pcosmode_p)
     d pcosmodec       s        2097152c   varying(4)
     d plainmetadata   s             10i 0
     d objtype         s             10i 0
     d i               s             10i 0
     d doc             s             10i 0
     d docoptlist      c                   %ucs2('requiredmode=minimum')
     d globaloptlist   c                   %ucs2('')
     d suffix          c                   '.txt'
     d contents        s          32767    based(contents_p)
     d len             s             10i 0
     d error           s             52
     d txt             s             52
     d n               s              1c   varying inz(%ucs2(''))
     d outfilename     s            256    varying
     d outfilebase     s            256    varying
     d outfd           s             10i 0
     d textc           s                   like(r_text_long_u)
     d crlf            s              2    inz(x'0D0A')
     d result_len      s             10i 0
     d page_nr         s             10i 0
     d width           s             10i 0
     d height          s             10i 0
      *********************************************************************************************
     d utf8_write      pr
     d  tet                            *   value
     d  outfd                        10i 0 value
     d  out                                value like(r_text_long_u)
      *********************************************************************************************
     c     *entry        plist
     c                   parm                    parm1           128
     c                   parm                    parm2           128

     c                   if        parm1 = *BLANKS or parm2 = *BLANKS
     c                   eval      error='usage: CALL PGM(DUMPER) '+
     c                                    'PARM(<in> <out>)'
     c                   exsr      exit
     c                   endif
      *********************************************************************************************
     c                   eval      tet=TET_new
     c                   if        tet=*null
     c                   eval      error='dumper: out of memory'
     c                   exsr      exit
     c                   endif

     c                   monitor

     c                   eval      outfilebase=%trim(parm2)
     c                   eval      outfilename=outfilebase+suffix

     c                   eval      outfd=open(outfilename:
     c                                     O_WRONLY+O_CREAT+O_TRUNC+O_EXCL :
     c                                     S_IRWXU+S_IRWXG)
     c                   if        outfd<0
     c                   eval      error='Couldn''t open "'+outfilename+'".'
     c                   callp     TET_delete(tet)
     c                   exsr      exit
     c                   endif

     c                   callp     TET_set_option(tet:globaloptlist)
     c
     c                   eval      doc=TET_open_document(tet:
     c                                     %ucs2(%trim(parm1)):docoptlist)
     c                   if        doc=-1
     c                   eval      error='Error '+
     c                               %char(TET_get_errnum(tet))+' in '+
     c                               %char(TET_get_apiname(tet)) + '(): ' +
     c                               %char(TET_get_errmsg(tet))
     c                   callp     TET_delete(tet)
     c                   exsr      exit
     c                   endif
      * --------- general information (always available)
     c                   eval      pcosmodec = TET_pcos_get_string(
     c                                            tet : doc :
     c                                            %ucs2('pcosmodename'))

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('File name: '))

     c                   eval      textc = TET_pcos_get_string(
     c                                        tet : doc : %ucs2('filename'))
     c                   callp     utf8_write(tet : outfd : textc)
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('PDF version: '))

     c                   eval      textc = TET_pcos_get_string(
     c                                         tet : doc :
     c                                         %ucs2('pdfversionstring'))
     c                   callp     utf8_write(tet : outfd : textc)
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('Encryption: '))

     c                   eval      textc = TET_pcos_get_string(
     c                                         tet : doc :
     c                                         %ucs2('encrypt/description'))
     c                   callp     utf8_write(tet : outfd : textc)
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('Master pw: '))

     c                   if        TET_pcos_get_number(tet:doc:
     c                                %ucs2('encrypt/master'))>0
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('yes'))
     c                   else
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('no'))
     c                   endif
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('User pw: '))

     c                   if        TET_pcos_get_number(tet:doc:
     c                                %ucs2('encrypt/user'))>0
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('yes'))
     c                   else
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('no'))
     c                   endif
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('Text copying: '))
     c                   if        TET_pcos_get_number(tet:doc:
     c                                %ucs2('encrypt/nocopy'))>0
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('yes'))
     c                   else
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('no'))
     c                   endif
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('Linearized: '))
     c                   if        TET_pcos_get_number(tet:doc:
     c                                %ucs2('linearized'))>0
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('yes'))
     c                   else
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('no'))
     c                   endif
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   if        pcosmodec = %ucs2('minimum')
     c                   callp     utf8_write(
     c                               tet :
     c                               outfd :
     c                               %ucs2('Minimum mode: ' +
     c                                     'no more information available'))
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   callp     TET_close_document(tet:doc+2)
     c                   callp     TET_delete(tet)
     c                   exsr      exit
     c                   endif

      * --------- more details (requires at least user password)
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('PDF/X status: '))

     c                   eval      textc = TET_pcos_get_string(
     c                                         tet : doc :
     c                                         %ucs2('pdfx'))
     c                   callp     utf8_write(tet : outfd : textc)
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('PDF/A status: '))

     c                   eval      textc = TET_pcos_get_string(
     c                                         tet : doc :
     c                                         %ucs2('pdfa'))
     c                   callp     utf8_write(tet : outfd : textc)
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('XFA data: '))

     c                   if        TET_pcos_get_number(tet:doc:
     c                                %ucs2('type:/Root/AcroForm/XFA'))>0
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('yes'))
     c                   else
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('no'))
     c                   endif
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('Tagged PDF: '))

     c                   if        TET_pcos_get_number(tet:doc:
     c                                %ucs2('tagged'))>0
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('yes'))
     c                   else
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('no'))
     c                   endif
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('No. of pages: '))
     c                   eval      page_nr = TET_pcos_get_number(
     c                                           tet : doc :
     c                                           %ucs2('length:pages'))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(%char(page_nr)))
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   callp     utf8_write(tet :
     c                                        outfd :
     c                                        %ucs2('Page 1 size: width='))
     c                   eval      width = TET_pcos_get_number(
     c                                             tet:doc:
     c                                             %ucs2('pages[0]/width'))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(%char(width)))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(', height='))
     c                   eval      height = TET_pcos_get_number(
     c                                        tet:doc:
     c                                        %ucs2('pages[0]/height'))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(%char(height)))
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   eval      count=TET_pcos_get_number(tet:doc:
     c                                     %ucs2('length:fonts'))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('No. of fonts: '))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(%char(count)))
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   sub       1             count
     c     0             do        count         i
     c                   if        TET_pcos_get_number(tet:doc:
     c                                 %ucs2('fonts['+%char(i)+']/embedded'))>0
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('embedded '))
     c                   else
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('unembedded '))
     c                   endif

     c                   eval      textc = TET_pcos_get_string(
     c                                       tet : doc :
     c                                       %ucs2('fonts['+%char(i)+']/type'))
      * print the retrieved text
     c                   callp     utf8_write(tet : outfd : textc)

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(' font '))
     c                   eval      textc = TET_pcos_get_string(
     c                                       tet : doc :
     c                                       %ucs2('fonts['+%char(i)+']/name'))
      * print the retrieved text
     c                   callp     utf8_write(tet : outfd : textc)
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)
     c                   enddo

     c                   eval      plainmetadata=TET_pcos_get_number(tet:doc:
     c                                     %ucs2('encrypt/plainmetadata'))

     c                   if        pcosmode=%ucs2('restricted')
     c                                   and plainmetadata=0 and
     c                                   TET_pcos_get_number(tet:doc:
     c                                     %ucs2('encrypt/nocopy'))>0
     c                   callp     utf8_write(
     c                               tet :
     c                               outfd :
     c                               %ucs2('Restricted mode: no more '))
     c                   callp     utf8_write(
     c                               tet :
     c                               outfd :
     c                               %ucs2('information available'))
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   callp     TET_close_document(tet:doc)
     c                   callp     TET_delete(tet)
     c                   exsr      exit
     c                   endif

      * --------- document info keys and XMP metadata (requires master pw
      * or plaintext metadata)
     c                   eval      count=TET_pcos_get_number(tet:doc:
     c                                     %ucs2('length:/Info'))
     c                   sub       1             count
     c     0             do        count         i
     c                   eval      objtype=TET_pcos_get_number(tet:doc:
     c                                     %ucs2('type:/Info['+%char(i)+']'))

     c                   eval      textc = TET_pcos_get_string(
     c                                       tet : doc :
     c                                       %ucs2('/Info['+%char(i)+'].key'))
      * print the retrieved text
     c                   callp     utf8_write(tet : outfd : textc)

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(': '))

      * Info entries can be stored as string or name objects
     c                   if        objtype=pcos_ot_string or
     c                             objtype=pcos_ot_name
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(''''))

     c                   eval      textc = TET_pcos_get_string(
     c                                       tet : doc :
     c                                       %ucs2('/Info['+%char(i)+']'))
      * print the retrieved text
     c                   callp     utf8_write(tet : outfd : textc)

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(''''))
     c                   else
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('('))

     c                   eval      textc = TET_pcos_get_string(
     c                                       tet : doc :
     c                                       %ucs2('type:/Info['+%char(i)+']'))
      * print the retrieved text
     c                   callp     utf8_write(tet : outfd : textc)

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(' object)'))
     c                   endif
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)
     c                   enddo

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('XMP meta data: '))

     c                   eval      objtype=TET_pcos_get_number(tet:doc:
     c                                     %ucs2('type:/Root/Metadata'))
     c                   if        objtype=pcos_ot_stream
     c                   eval      contents_p =
     c                                TET_pcos_get_stream(
     c                                   tet:doc:len:n:
     c                                   %ucs2('/Root/Metadata'))
     c
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(%char(len)))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(' bytes '))

      * This demonstrates Unicode conversion
     C                   callp     TET_convert_to_unicode (
     C                                tet :
     C                                %ucs2('utf8') :
     C                                contents :
     C                                len :
     C                                result_len :
     C                                %ucs2('outputformat=utf16'))

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('('))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(%char(result_len)))
     c                   callp     utf8_write(tet :
     c                                        outfd :
     c                                        %ucs2(' Unicode characters)'))
     c                   else
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('not presentet'))
     c                   endif
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)
      * Error Handling
     c                   on-error
     c                   exsr      dsperror
     c                   endmon

     c                   callp     close(outfd)

     c                   callp     TET_close_document(tet:doc)
     c                   callp     TET_delete(tet)
      *
     c                   exsr      exit
      *********************************************************************************************
      * unmonitored error occured
     c     *pssr         begsr
     c                   if        tet<>*null
     c                   callp     TET_delete(tet)
     c                   endif
     c                   eval      error='General program failure.'
     c     error         dsply
     c                   endsr     '*CANCL'
      *********************************************************************************************
     c     dsperror      begsr
     c                   eval      txt='TET exception occured in dumper:'
     c     txt           dsply
     c                   eval      txt=
     c                               %char(TET_get_errnum(tet))+' in '+
     c                               %char(TET_get_apiname(tet)) + '(): ' +
     c                               %char(TET_get_errmsg(tet))
     c     txt           dsply
     c                   endsr
      *********************************************************************************************
     c     exit          begsr
     c                   if        error<>*blanks
     c                   eval      error='Error: '+error
     c     error         dsply
     c                   endif
     c                   seton                                        lr
     c                   return
     c                   endsr
      *********************************************************************************************
     p utf8_write      b

     d utf8_write      pi
     d  tet                            *   value
     d  outfd                        10i 0 value
     d  out                                value like(r_text_long_u)

     d out_fix         s          16383c
     d rtn_value       s          32767    based(rtn_value_p)
     d len_out         s             10i 0
     d rtnlen          s             10i 0
     d convert_value   s          65535    based(convert_value_p)
     d result          s             10i 0

      /free
          out_fix = out;
          rtn_value_p = %addr(out_fix);
          len_out = %len(out);

          convert_value_p = TET_convert_to_unicode (
                              tet :
                              %ucs2('utf16') :
                              rtn_value :
                              len_out * 2 :
                              rtnlen :
                              %ucs2('outputformat=utf8'));

          result = write(outfd : convert_value_p : len_out);
      /end-free
     p utf8_write      e
