     H DEBUG(*YES) DFTACTGRP(*NO) BNDDIR('TETLIB/TETLIB')
     H COPYRIGHT('(c) PDFlib GmbH (www.pdflib.com)')
      *********************************************************************************************
      *   Simple PDF glyph dumper based on PDFlib TET
      *
      *   Note: All strings passed into PDFlib are unicode strings with varying length.
      *         Use the %UCS2 build in function to convert a single byte string into a unicode string.
      *         All strings returned from PDFlib are unicode strings with varying length.
      *         Use the %CHAR build in function to convert a unicode string to a single byte string.
      *********************************************************************************************
     d/copy QRPGLESRC,TETLIB
     d/copy QRPGLESRC,IFSIO

     d globaloptlist   c                   %ucs2('searchpath={{../data} -
     d                                     {../../../resource/cmap}}')
     d docoptlist      c                   %ucs2('')
     d pageoptlist     c                   %ucs2('granularity=word')
     d error           s             52
     d error1          s            512
     d tet             s               *
     d pageno          s             10i 0
     d length          s             10i 0
     d n_pages         s             10i 0
     d doc             s             10i 0
     d pdfpage         s             10i 0
     d len             s             10i 0
     d text            s           9999c   based(text_p)
     d crlf            s              2    inz(x'0D0A')
     d outfd           s             10i 0
     d outfilename     s            256    varying
     d fontname        s            256c   varying
     d hx              c                   '0123456789ABCDEF'
     d hex             s              4
     d val             s             10i 0
     d csname          s           1024c
     d i_count         s             10i 0
     d patterntype     s              8f
     d painttype       s              8f
     d shadingtype     s              8f
     d iccprofileid    s              8f
     d iccprofileid_int...
     d                 s             10i 0
     d profilename     s           1024c
     d profilecs       s           1024c
     d errormessage    s           1024c
     d colorantname    s           1024c
     d baseid          s              8f
     d previouscolorid...
     d                 s             10i 0
     d component       s             10i 0
     d errnoValue      s             10i 0

     d coi             ds                  likeDS(TET_color_info)
     d                                     based(coi_p)

     D IFSerrno        PR            10I 0

     d                 ds
     d outdta                  1   1024
     d                 ds
     d u_uv                    1      2u 0
     d u_uc                    1      2c
      *********************************************************************************************
     d utf8_write      pr
     d  tet                            *   value
     d  outfd                        10i 0 value
     d  out                                value like(r_text_long_u)
      *********************************************************************************************
     c     *entry        plist
     c                   parm                    parm1           256
     c                   parm                    parm2           256

     c                   if        %parms<2
     c                   eval      error='usage: call PGM(GLYPHINFO) '+
     c                                   'PARM(''<infile>'' ''<outfile>'')'
     c                   exsr      exit
     c                   endif

     c                   eval      outfilename=%trim(parm2)

     c                   eval      tet=TET_new
     c                   if        tet=*null
     c                   eval      error='glyphinfo: out of memory'
     c                   exsr      exit
     c                   endif

     c                   eval      outfd=open(outfilename:
     c                                     O_WRONLY+O_CREAT+O_TRUNC+O_EXCL :
     c                                     S_IRWXU+S_IRWXG)
     c                   if        outfd<0
     c                   eval      errnoValue = IFSerrno()
     c                   callp     TET_delete(tet)
     c                   eval      error='Couldn''t open output file '+
     c                                    ''''+outfilename+''''
     c                   exsr      exit
     c                   endif

     c                   monitor

     c                   callp     TET_set_option(tet: globaloptlist)
     c                   eval      doc=TET_open_document(tet:
     c                                     %ucs2(%trim(parm1)):docoptlist)
     c                   if        doc=-1
     c                   eval      error='Error '+
     c                               %char(TET_get_errnum(tet))+' in '+
     c                               %char(TET_get_apiname(tet))+'(): '+
     c                               %char(TET_get_errmsg(tet))
     c                   eval      error1='Error '+
     c                               %char(TET_get_errnum(tet))+' in '+
     c                               %char(TET_get_apiname(tet))+'(): '+
     c                               %char(TET_get_errmsg(tet))
     c                   callp     TET_delete(tet)
     c                   exsr      exit
     c                   endif

      *   get number of pages in the document
     c                   eval(h)   n_pages=TET_pcos_get_number(tet: doc:
     c                                      %ucs2('length:pages'))

      *   loop over pages in the document
     c                   do        n_pages       pageno
     c                   eval      previouscolorid = -1
     c                   eval      pdfpage=TET_open_page(tet: doc: pageno:
     c                                                   pageoptlist)
     c                   if        pdfpage=-1
     c                   eval      error='Error '+
     c                               %char(TET_get_errnum(tet))+' in '+
     c                               %char(TET_get_apiname(tet))+' on page '+
     c                               %char(pageno)+': ' +
     c                               %char(TET_get_errmsg(tet))
     c     error         dsply
     c                   iter
     c                   endif
      *   Administrative information
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('[ Document: '))
     c                   callp     utf8_write(tet : outfd : fontname)
     c                   eval      fontname = TET_pcos_get_string(tet: doc:
     c                                          %ucs2('filename'))
     c                   callp     utf8_write(tet : outfd : fontname)
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(']'))
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   callp     utf8_write(tet :
     c                                        outfd :
     c                                        %ucs2('[ Document options: '))
     c                   callp     utf8_write(tet : outfd : docoptlist)
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(']'))
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   callp     utf8_write(tet :
     c                                        outfd :
     c                                        %ucs2('[ Page options: '))
     c                   callp     utf8_write(tet : outfd : pageoptlist)
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(']'))
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

     c                   callp     utf8_write(tet :
     c                                        outfd :
     c                                        %ucs2('[ ---- Page '))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(%char(pageno)))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(' ---- ]'))
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

      *   Retrieve all text fragments
     c                   do        *hival
     c                   eval      text_p=TET_get_text(tet: pdfpage: len)
     c                   if        text_p=*null
     c                   leave
     c                   endif

     c                   callp     utf8_write(tet :
     c                                        outfd :
     c                                        %ucs2('['))
     c                   callp     write(outfd : %addr(text) :
     c                                    %len(%str(text_p)))

     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(']'))
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)

      *    Loop over all glyphs and print their details
     c                   do        *hival
     c                   eval      tet_char_info_p=TET_get_char_info(tet:
     c                                                              pdfpage)
     c                   if        tet_char_info_p=*null
     c                   leave
     c                   endif

      *    Fetch the font name with pCOS (based on its ID)
     c                   eval      fontname=TET_pcos_get_string(tet:doc:
     c                               %ucs2('fonts['+%char(ci_fontid)+']/name'))
      *    Print the Unicode value...
     c                   eval      val=ci_uv
     c                   eval      hex=''
     c                   do        4
     c                   eval      hex=%subst(hx:%rem(val:16)+1:1)+hex
     c                   eval      val=val/16
     c                   enddo

     c                   callp     utf8_write(tet :
     c                                        outfd :
     c                                        %ucs2('U+'))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(hex))

      *    ...and the character itself if it is ASCII
     c                   if        ci_uv>=32 and ci_uv<=127
     c                   eval      u_uv=ci_uv

     c                   callp     utf8_write(tet :
     c                                        outfd :
     c                                        %ucs2(' '''))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(%char(u_uc)))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(''''))
     c                   else
     c                   callp     utf8_write(tet :
     c                                        outfd :
     c                                        %ucs2(' ???'))
     c                   endif

      *    Print font name, size, and position */
     c                   z-add     ci_fontsize   fontsize72        7 2
     c                   z-add     ci_x          x72               7 2
     c                   z-add     ci_y          y72               7 2

     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' '))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(%char(fontname)))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' size='))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(%char(fontsize72)))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' x='))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(%char(x72)))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' y='))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(%char(y72)))
      *    Print the color id
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' colorid='))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(%char(ci_colorid)))

      *    Check whether the text color changed
     c                   if        ci_colorid <> previouscolorid
     c                   exsr      prt_col_val
     c                   eval      previouscolorid = ci_colorid
     c                   endif

      *    Examine the "type" member
     c                   select

     c                   when      ci_type = TET_CT_SEQ_START
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' ligature_start'))

     c                   when      ci_type = TET_CT_SEQ_CONT
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' ligature_cont'))

     c                   when      ci_type = TET_CT_INSERTED
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' inserted'))
     c                   endsl

      *    Examine the bit flags in the "attributes" member
     c                   if        ci_attributes <> TET_ATTR_NONE

     c                   select

     c                   when      %BITAND (ci_attributes : TET_ATTR_SUB) > 0
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' /sub'))

     c                   when      %BITAND (ci_attributes : TET_ATTR_SUP) > 0
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' /sup'))

     c                   when      %BITAND (ci_attributes :
     c                                      TET_ATTR_DROPCAP) > 0
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' /dropcap'))

     c                   when      %BITAND (ci_attributes : TET_ATTR_SHADOW) > 0
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' /shadow'))

     c                   when      %BITAND (ci_attributes :
     c                                     TET_ATTR_DEHYPHENATION_PRE) > 0
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' /dehyphenation_pre'))

     c                   when      %BITAND (ci_attributes :
     c                                     TET_ATTR_DEHYPHENATION_ARTIFACT) > 0
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' /dehyphenation_artifact'))

     c                   when      %BITAND (ci_attributes :
     c                                     TET_ATTR_DEHYPHENATION_POST) > 0
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' /dehyphenation_post'))

     c                   when      %BITAND (ci_attributes :
     c                                      TET_ATTR_ARTIFACT) > 0
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' /Artifact'))
     c                   endsl
     c                   endif
      * empty line
     c                   callp     write(outfd : %addr(crlf) : 2)
     c                   enddo
     c                   enddo
     c                   enddo
      * Error Handling
     c                   on-error
     c                   exsr      dsperror
     c                   endmon

     c                   callp     close(outfd)
     c                   callp     TET_delete(tet)

     c                   exsr      exit
      *********************************************************************************************
      *  Write record
     c     wrtout        begsr
     c                   eval      length=%len(%trimr(outdta))
      *  If necessary prints a ' '
     c                   if        length = 0
     c                   eval      length = 1
     c                   endif
     c
     c                   callp     write(outfd:%addr(outdta):length)
     c                   endsr
      *********************************************************************************************
     c     dsperror      begsr
     c                   eval      error='TET exception occured in glyphinfo:'
     c     error         dsply
     c                   eval      error=
     c                               %char(TET_get_errnum(tet))+' in '+
     c                               %char(TET_get_apiname(tet))+'(): '+
     c                               %char(TET_get_errmsg(tet))
     c     error         dsply
     c                   endsr
      *********************************************************************************************
     c     exit          begsr
     c                   if        error<>*blanks
     c                   eval      error='Error: '+error
     c     error         dsply
     c                   endif
     c                   seton                                        lr
     c                   return
     c                   endsr
      *********************************************************************************************
      *  Print color space and color value details of a glyph's fill color
     c     prt_col_val   begsr

      *  We handle only the fill color, but ignore the stroke color.
      *  The stroke color can be retrieved analogously with the
      *  keyword "stroke".
     c                   eval      coi_p = TET_get_color_info(
     c                                       tet:
     c                                       doc:
     c                                       ci_colorid:
     c                                       %ucs2('usage=fill'))
     c                   if        coi.colorspaceid = -1 and
     c                               coi.patternid = -1
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' (not filled)'))
     c                   goto      endsr
     c                   endif
     c
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' ('))
     c
     c                   if        coi.patternid <> -1
     c                   eval      patterntype =
     c                               TET_pcos_get_number(
     c                                 tet:
     c                                 doc:
     c                                 %ucs2('patterns[' +
     c                                         %char(coi.patternid) +
     c                                          ']/PatternType'))
     c                   if        patterntype = 1                              Tiling pattern
     c                   eval      painttype =
     c                               TET_pcos_get_number(
     c                                 tet:
     c                                 doc:
     c                                 %ucs2('patterns[' +
     c                                         %char(coi.patternid) +
     c                                         ']/PaintType'))
     c                   if        painttype = 1
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2('colored Pattern)'))
     c                   goto      endsr
     c
     c                   elseif    painttype = 2
     c                   callp     utf8_write(
     c                               tet : outfd :
     c                               %ucs2('uncolored Pattern, base color: '))
      *  FALLTHROUGH to colorspaceid output
     c                   endif
     c
     c                   elseif    patterntype = 2                              Shading pattern
     c                   eval      shadingtype =
     c                               TET_pcos_get_number(
     c                                 tet:
     c                                 doc:
     c                                 %ucs2('patterns[' +
     c                                         %char(coi.patternid) +
     c                                         ']/Shading/ShadingType'))
     c                   callp     utf8_write(
     c                               tet : outfd :
     c                               %ucs2('shading Pattern, ShadingType='))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(%char(shadingtype)))
     c                   goto      endsr
     c                   endif
     c                   endif
     c
     c                   eval      csname = TET_pcos_get_string(
     c                                        tet:
     c                                        doc:
     c                                        %ucs2('colorspaces[' +
     c                                          %char(coi.colorspaceid) +
     c                                          ']/name'))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(%trim(csname)))

      * Emit more details depending on the colorspace type
     c                   if        %trim(csname) = 'ICCBased'
     c                   eval      iccprofileid =
     c                               TET_pcos_get_number(
     c                                 tet:
     c                                 doc:
     c                                 %ucs2('colorspaces[0]/iccprofileid'))
     c                   eval      iccprofileid_int = iccprofileid
     c                   eval      errormessage = TET_pcos_get_string(
     c                               tet:
     c                               doc:
     c                               %ucs2('iccprofiles[' +
     c                                       %char(iccprofileid_int) +
     c                                       ']/errormessage'))

      * Check whether the embedded profile is damaged
     c                   if        errormessage <> *blanks
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' ('))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(%trim(%char(errormessage))))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(')'))
     c
     c                   else
     c                   eval      profilename =
     c                               TET_pcos_get_string(
     c                                 tet:
     c                                 doc:
     c                                 %ucs2('iccprofiles[' +
     c                                         %char(iccprofileid_int) +
     c                                         ']/profilename'))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' '))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(%trim(%char(errormessage))))
     c                   eval      profilecs =
     c                               TET_pcos_get_string(
     c                                 tet:
     c                                 doc:
     c                                 %ucs2('iccprofiles[' +
     c                                         %char(iccprofileid_int) +
     c                                         ']/profilecs'))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' '''))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(%trim(%char(profilecs))))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(''''))
     c                   endif
     c
     c                   elseif    %trim(csname) = 'Separation'
     c                   eval      colorantname =
     c                               TET_pcos_get_string(
     c                                 tet:
     c                                 doc:
     c                                 %ucs2('colorspaces[' +
     c                                         %char(coi.colorspaceid) +
     c                                         ']/colorantname'))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' '''))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(%trim(%char(colorantname))))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(''''))
     c
     c                   elseif    %trim(csname) = 'DeviceN'
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' '))

     c                   for       i_count = 1 to coi.n
     c                   eval      colorantname =
     c                               TET_pcos_get_string(
     c                                 tet:
     c                                 doc:
     c                                 %ucs2('colorspaces[' +
     c                                         %char(coi.colorspaceid) +
     c                                         ']/colorantnames' +
     c                                         %char(i_count)))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(%trim(colorantname)))

     c                   if        i_count <> coi.n
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2('/'))
     c                   endif
     c                   endfor
     c
     c                   elseif    %trim(csname) = 'Indexed'
     c                   eval      baseid =
     c                               TET_pcos_get_number(
     c                                 tet:
     c                                 doc:
     c                                 %ucs2('colorspaces[' +
     c                                         %char(coi.colorspaceid) +
     c                                          ']/baseid'))
     c                   eval      csname = TET_pcos_get_string(
     c                                        tet:
     c                                        doc:
     c                                        %ucs2('colorspaces[' +
     c                                                %char(baseid) +
     c                                                ']/name'))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' '))
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(%trim(%char(csname))))
     c                   endif

     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(' '))

     c                   for       i_count = 1 to coi.n
      *  For editing
     c                   eval      component = coi.components(i_count)
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(%char(component)))

     c                   if        i_count <> coi.n
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2('/'))
     c                   endif
     c                   endfor
     c
     c                   callp     utf8_write(tet : outfd :
     c                                        %ucs2(')'))
     C     endsr         ENDSR

     P IFSerrno        B
     D IFSerrno        PI            10I 0
     D p_errno         S               *
     D retval          S             10I 0 based(p_errno)
     c                   eval      p_errno = Geterrno
     c                   return    retval
     P                 E
      *********************************************************************************************
     p utf8_write      b

     d utf8_write      pi
     d  tet                            *   value
     d  outfd                        10i 0 value
     d  out                                value like(r_text_long_u)

     d out_fix         s          16383c
     d rtn_value       s          32767    based(rtn_value_p)
     d len_out         s             10i 0
     d rtnlen          s             10i 0
     d convert_value   s          65535    based(convert_value_p)
     d result          s             10i 0

      /free
          out_fix = out;
          rtn_value_p = %addr(out_fix);
          len_out = %len(out);

          convert_value_p = TET_convert_to_unicode (
                              tet :
                              %ucs2('utf16') :
                              rtn_value :
                              len_out * 2 :
                              rtnlen :
                              %ucs2('outputformat=utf8'));

          result = write(outfd : convert_value_p : len_out);
      /end-free
     p utf8_write      e