     H DEBUG(*YES) DFTACTGRP(*NO) BNDDIR('TETLIB/TETLIB')
     H COPYRIGHT('(c) PDFlib GmbH (www.pdflib.com)')
      *********************************************************************************************
      *   Resource-based image extractor based on PDFlib TET
      *
      *   Note: All strings passed into PDFlib are unicode strings with varying length.
      *         Use the %UCS2 build in function to convert a single byte string into a unicode string.
      *         All strings returned from PDFlib are unicode strings with varying length.
      *         Use the %CHAR build in function to convert a unicode string to a single byte string.
      *********************************************************************************************
     d/copy QRPGLESRC,TETLIB
     d/copy QRPGLESRC,IFSIO

     d globaloptlist   c                   %ucs2('searchpath={{../data}}')
     d docoptlist      c                   %ucs2('')
      *  page-specific option list, e.g.
      *  "imageanalysis={merge={gap=1}}"
     d pageoptlist     c                   %ucs2('')
     d baseimageoptlist...
     d                 c                   %ucs2('')
     d suffix          c                   '.txt'

     d imageoptlist    s            256c   varying
     d error           s             52
     d error1          s            512
     d tet             s               *
     d pageno          s             10i 0
     d n_pages         s             10i 0
     d imageid         s             10i 0
     d n_image         s             10i 0
     d mergetype       s             10i 0
     d doc             s             10i 0
     d pdfpage         s             10i 0
     d infile          s            256c   varying
     d outfilename     s            256    varying
     d outfd           s             10i 0

     d report_image_info...
     d                 pr
     d tet                             *   value
     d doc                           10i 0 value
     d imageid                       10i 0 value
     d outfd                         10i 0 value

     d utf8_write      pr
     d  tet                            *   value
     d  outfd                        10i 0 value
     d  out                                value like(r_text_long_u)
      *********************************************************************************************
     c     *entry        plist
     c                   parm                    parm1           128
     c                   parm                    parm2           128

     c                   if        parm1 = *BLANKS or parm2 = *BLANKS
     c                   eval      error='usage: call PGM(IMAGE_RESO) '+
     c                                   'PARM(<infile> <outfile>)'
     c                   exsr      exit
     c                   endif

     c                   eval      infile = %ucs2(%trim(parm1))

     c                   eval      tet=TET_new
     c                   if        tet=*null
     c                   eval      error='image_reso: out of memory'
     c                   exsr      exit
     c                   endif

     c                   monitor

     c                   eval      outfilename = %trim(parm2)
     c                   eval      outfilename += suffix

     c                   eval      outfd=open(outfilename:
     c                                     O_WRONLY+O_CREAT+O_TRUNC+O_EXCL :
     c                                     S_IRWXU+S_IRWXG)
     c                   if        outfd<0
     c                   eval      error='Couldn''t open "'+outfilename+'".'
     c                   callp     TET_delete(tet)
     c                   exsr      exit
     c                   endif

     c                   callp     TET_set_option(tet: globaloptlist)
     c                   eval      doc = TET_open_document(tet :
     c                                                     infile : docoptlist)
     c                   if        doc=-1
     c                   eval      error='Error '+
     c                               %char(TET_get_errnum(tet))+' in '+
     c                               %char(TET_get_apiname(tet))+'(): '+
     c                               %char(TET_get_errmsg(tet))
     c                   eval      error1='Error '+
     c                               %char(TET_get_errnum(tet))+' in '+
     c                               %char(TET_get_apiname(tet))+'(): '+
     c                               %char(TET_get_errmsg(tet))
     c                   callp     TET_delete(tet)
     c                   exsr      exit
     c                   endif
      *  Get number of pages in the document
     c                   eval(h)   n_pages=TET_pcos_get_number(tet: doc:
     c                                      %ucs2('length:pages'))

      *  Loop over all pages to trigger image merging
     c                   do        n_pages       pageno
     c                   eval      pdfpage=TET_open_page(tet: doc: pageno:
     c                                                   pageoptlist)
     c                   if        pdfpage=-1
     c                   eval      error='Error '+
     c                               %char(TET_get_errnum(tet))+' in '+
     c                               %char(TET_get_apiname(tet))+' on page '+
     c                               %char(pageno)+': ' +
     c                               %char(TET_get_errmsg(tet))
     c     error         dsply
     c                   iter
     c                   endif
      *   Administrative information
     c                   if        TET_get_errnum(tet) <> 0
     c                   eval      error='Error '+
     c                               %char(TET_get_errnum(tet))+' in '+
     c                               %char(TET_get_apiname(tet))+' on page '+
     c                               %char(pageno)+': ' +
     c                               %char(TET_get_errmsg(tet))
     c     error         dsply
     c                   endif
      *
     c                   callp     TET_close_page(tet: pdfpage)
      *
     c                   enddo

      *  Get the number of images in the document
     c                   eval      n_image = TET_pcos_get_number(tet: doc:
     c                                                 %ucs2('length:images'))
     c                   eval      n_image-=1
      *  Loop over all image resources
     c     0             do        n_image       imageid
      *    examine image type
     c                   eval      mergetype = TET_pcos_get_number(tet: doc:
     c                              %ucs2('images['+%char(imageid)+
     c                                                      ']/mergetype'))
      *    Skip images which have been consumed by merging
     c                   if        mergetype = 2
     c                   iter
     c                   endif

      *  Skip images which have been flagged by the "small image" filter
     c                   if        TET_pcos_get_number(tet:
     c                                                 doc:
     c                                                 %ucs2('images[' +
     c                                                         %char(imageid) +
     c                                                         ']/small')) = 1
     c                   iter
     c                   endif
      *  Report image details: pixel geometry, color space, etc.
     c                   callp     report_image_info(tet :
     c                                               doc : imageid : outfd)
      *  Write image data to file
     c                   eval      imageoptlist = baseimageoptlist +
     c                                %ucs2('filename={') + infile +
     c                                %ucs2('_I' + %char(imageid) + '}')
     c                   if        TET_write_image_file(tet: doc: imageid:
     c                                  imageoptlist)=-1
     c                   eval      error='Error '+
     c                               %char(TET_get_errnum(tet))+' in '+
     c                               %char(TET_get_apiname(tet))+'(): '+
     c                               %char(TET_get_errmsg(tet))
     c     error         dsply
     c                   iter
     c                   endif
     c                   enddo

     c                   callp     TET_close_document(tet: doc)

      * Error Handling
     c                   on-error
     c                   exsr      dsperror
     c                   endmon

     c                   callp     TET_delete(tet)

     c                   exsr      exit
      *********************************************************************************************
     c     dsperror      begsr
     c                   eval      error='TET exception occured in image_reso'
     c     error         dsply
     c                   eval      error=
     c                               %char(TET_get_errnum(tet))+' in '+
     c                               %char(TET_get_apiname(tet))+'(): '+
     c                               %char(TET_get_errmsg(tet))
     c     error         dsply
     c                   endsr
      *********************************************************************************************
     c     exit          begsr
     c                   if        error<>*blanks
     c                   eval      error='Error: '+error
     c     error         dsply
     c                   endif
     c                   seton                                        lr
     c                   return
     c                   endsr
      *
      *********************************************************************************************
      * Print the following information for each image:
      * - pCOS id (required for indexing the images[] array)
      * - pixel size of the underlying PDF Image XObject
      * - number of components, bits per component, and colorspace
      * - mergetype if different from "normal", i.e. "artificial" (=merged)
      *   or "consumed"
      * - "stencilmask" property, i.e. /ImageMask in PDF
      * - pCOS id of mask image, i.e. /Mask or /SMask in PDF
     p report_image_info...
     p                 b
     d report_image_info...
     d                 pi
     d tet                             *   value
     d doc                           10i 0 value
     d imageid                       10i 0 value
     d outfd                         10i 0 value

     d crlf            s              2    inz(x'0D0A')

     d width           s             10i 0
     d height          s             10i 0
     d bpc             s             10i 0
     d cs              s             10i 0
     d components      s             10i 0
     d basecs          s             10i 0
     d mergetype       s             10i 0
     d stencilmask     s             10i 0
     d maskid          s             10i 0
     d csname          s           1024c
     d basecsname      s           1024c

     c                   eval(h)   width = TET_pcos_get_number(tet: doc:
     c                                     %ucs2('images['+%char(imageid)+
     c                                                          ']/Width'))
     c                   eval(h)   height= TET_pcos_get_number(tet: doc:
     c                                     %ucs2('images['+%char(imageid)+
     c                                                          ']/Height'))
     c                   eval(h)   bpc   = TET_pcos_get_number(tet: doc:
     c                                     %ucs2('images['+%char(imageid)+
     c                                                          ']/bpc'))
     c                   eval(h)   cs    = TET_pcos_get_number(tet: doc:
     c                                     %ucs2('images['+%char(imageid)+
     c                                                       ']/colorspaceid'))
     c                   eval      components =
     c                               TET_pcos_get_number(
     c                                 tet:
     c                                 doc:
     c                                 %ucs2('colorspaces[' +
     c                                         %char(cs) +
     c                                          ']/components'))
     c
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('image I'))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(%char(imageid)))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(': '))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(%char(width)))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('x'))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(%char(height)))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(' pixel, '))
     c                   eval      csname = TET_pcos_get_string(
     c                                        tet:
     c                                        doc:
     c                                        %ucs2('colorspaces[' +
     c                                                %char(cs) +
     c                                                 ']/name'))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(%char(components)))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2('x'))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(%char(bpc)))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(' bit '))
     c                   callp     utf8_write(tet :
     c                                        outfd :
     c                                        %ucs2(%char(%trim(csname))))
     c
     c                   if        %trim(csname) = 'Indexed'
     c                   eval      basecs =
     c                               TET_pcos_get_number(
     c                                 tet:
     c                                 doc:
     c                                 %ucs2('colorspaces[' +
     c                                         %char(cs) +
     c                                          ']/baseid'))
     c                   eval      basecsname = TET_pcos_get_string(
     c                                            tet:
     c                                            doc:
     c                                            %ucs2('colorspaces[' +
     c                                                    %char(basecs) +
     c                                                    ']/name'))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(' '))
     c                   callp     utf8_write(tet :
     c                                        outfd :
     c                                        %ucs2(%char(%trim(basecsname))))
     c                   endif
     c
      *  Check whether the image has been created by merging smaller images
     c                   eval      mergetype =
     c                               TET_pcos_get_number(
     c                                 tet:
     c                                 doc:
     c                                 %ucs2('images[' +
     c                                         %char(imageid) +
     c                                          ']/mergetype'))
     c                   if        mergetype = 1
     c                   callp     utf8_write(tet :
     c                                        outfd :
     c                                        %ucs2(', mergetype=artificial'))
     c                   endif

     c                   eval      stencilmask =
     c                               TET_pcos_get_number(
     c                                 tet:
     c                                 doc:
     c                                 %ucs2('images[' +
     c                                         %char(imageid) +
     c                                          ']/stencilmask'))
     c                   if        stencilmask <> 0
     c                   callp     utf8_write(tet :
     c                                        outfd :
     c                                        %ucs2(', used as stencil mask'))
     c                   endif

      *  Check whether the image has an attached mask
     c                   eval      maskid =
     c                               TET_pcos_get_number(
     c                                 tet:
     c                                 doc:
     c                                 %ucs2('images[' +
     c                                         %char(imageid) +
     c                                          ']/maskid'))
     c                   if        maskid <> -1
     c                   callp     utf8_write(tet :
     c                                        outfd :
     c                                        %ucs2(', masked with image '))
     c                   callp     utf8_write(tet :
     c                                        outfd : %ucs2(%char(maskid)))
     c                   endif
      * new line
     c                   callp     write(outfd : %addr(crlf) : 2)
     c                   return

     p report_image_info...
     p                 e
      *********************************************************************************************
     p utf8_write      b

     d utf8_write      pi
     d  tet                            *   value
     d  outfd                        10i 0 value
     d  out                                value like(r_text_long_u)

     d out_fix         s          16383c
     d rtn_value       s          32767    based(rtn_value_p)
     d len_out         s             10i 0
     d rtnlen          s             10i 0
     d convert_value   s          65535    based(convert_value_p)
     d result          s             10i 0

      /free
          out_fix = out;
          rtn_value_p = %addr(out_fix);
          len_out = %len(out);

          convert_value_p = TET_convert_to_unicode (
                              tet :
                              %ucs2('utf16') :
                              rtn_value :
                              len_out * 2 :
                              rtnlen :
                              %ucs2('outputformat=utf8'));

          result = write(outfd : convert_value_p : len_out);
      /end-free
     p utf8_write      e