      **************************************************************************
      *       Copyright (c) 2005-2022 PDFlib GmbH. All rights reserved.        *
      **************************************************************************
      * This software may not be copied or distributed except as expressly     *
      * authorized by PDFlib GmbH's general license agreement or a custom      *
      * license agreement signed by PDFlib GmbH.                               *
      * For more information about licensing please refer to www.pdflib.com.   *
      **************************************************************************

      **************************************************************************
      *  TETlib Constants and Prototypes for ILE RPG Version 2                 *
      **************************************************************************
      *
     d r_order_u       s            128c   varying
     d r_order_s       s            128    varying
     d r_order         s            128
     d r_optlist_u     s            512c   varying
     d r_optlist_s     s            512    varying
     d r_optlist       s            512
     d r_filename_u    s            512c   varying
     d r_filename_s    s            512    varying
     d r_filename      s            512
     d r_path_u        s            512c   varying
     d r_path_s        s            512    varying
     d r_path          s            512
     d r_string_u      s          16000c   varying
     d r_string_s      s          16000    varying
     d r_string        s          16000
     d r_text_u        s           2048c   varying
     d r_text          s           2048
     d r_text_long_u   s          16383c   varying
     d r_text_long_s   s          32767
      **************************************************************************
     d/if not defined(NO_RPG_PROTOTYPES)
      **************************************************************************

     d TET_close_...
     d document        pr                  extproc('RTET_CLOSE_DOCUMENT')
     d  tet                            *   value
     d  tet_doc                      10i 0 value

     d TET_...
     d close_page      pr                  extproc('RTET_CLOSE_PAGE')
     d  tet                            *   value
     d  tet_page                     10i 0 value

     d TET_...
     d create_pvf      pr                  extproc('RTET_CREATE_PVF')
     d  tet                            *   value
     d  tet_filename                       value like(r_filename_u)
     d  tet_data                       *   value
     d  tet_datalen                  10i 0 value
     d  tet_optlist                        value like(r_optlist_u)

     d TET_delete      pr                  extproc('TET_delete')
     d  tet                            *   value

     d TET_...
     d delete_pvf      pr                  extproc('RTET_DELETE_PVF')
     d  tet                            *   value
     d  tet_filename                       value like(r_filename_u)

     d TET_info_pvf...
     d                 pr             8f   extproc('RTET_info_pvf')
     d  tet                            *   value
     d  filename                           value like(r_filename_u)
     d  keyword                            value like(r_optlist_u)


     d TET_convert_to_unicode...
     d                 pr              *
     d                                     extproc('RTET_CONVERT_TO_UNICODE')
     d  tet                            *   value
     d  inputformat                        value like(r_text_u)
     d  inputstring               32767    options(*varsize)
     d  inputlen                     10i 0 value
     d  outputlen                    10i 0
     d  optlist                            value like(r_optlist_u)

     d TET_get_...
     d apiname         pr          1024c   varying
     d                                     extproc('RTET_GET_APINAME')
     d  tet                            *   value

     d TET_get_...
     d char_info       pr              *   extproc('RTET_GET_CHAR_INFO')
     d  tet                            *   value
     d  tet_page                     10i 0 value

     d TET_get_color_info...
     d                 pr              *   extproc('RTET_GET_COLOR_INFO')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_color                    10i 0 value
     d  tet_optlist                        value like(r_optlist_u)

     d TET_...
     d get_errmsg      pr          1024c   varying
     d                                     extproc('RTET_GET_ERRMSG')
     d  tet                            *   value

     d TET_...
     d get_errnum      pr            10i 0 extproc('RTET_GET_ERRNUM')
     d  tet                            *   value

     d TET_get_image_...
     d data            pr              *
     d                                     extproc('RTET_GET_IMAGE_DATA')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_len                      10i 0
     d  tet_imgid                    10i 0 value
     d  tet_optlist                        value like(r_optlist_u)

     d TET_...
     d get_image_...
     d info            pr              *   extproc('RTET_GET_IMAGE_INFO')
     d  tet                            *   value
     d  tet_page                     10i 0 value

     d TET_...
     d get_tetml       pr              *   extproc('RTET_GET_TETML')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_len                      10i 0
     d  tet_optlist                        value like(r_optlist_u)

     d TET_get_...
     d text            pr              *   extproc('RTET_GET_TEXT')
     d  tet                            *   value
     d  tet_page                     10i 0 value
     d  tet_len                      10i 0

     d TET_new         pr              *   extproc('RTET_NEW')

     d TET_open_...
     d document        pr            10i 0 extproc('RTET_OPEN_DOCUMENT')
     d  tet                            *   value
     d  tet_filename                       value like(r_filename_u)
     d  tet_optlist                        value like(r_optlist_u)

     d TET_open_...
     d document_mem    pr            10i 0 extproc('RTET_OPEN_DOCUMENT_MEM')
     d  tet                            *   value
     d  tet_data                       *   value
     d  tet_len                      10i 0 value
     d  tet_optlist                        value like(r_optlist_u)

     d TET_open_...
     d document_...
     d callback        pr            10i 0 extproc('RTET_OPEN_DOCUMENT_C-
     d                                     CALLBACK')
     d  tet                            *   value
     d  opaque                         *   value
     d  filesize                     10i 0 value
     d  readproc                       *   value
     d  seekproc                       *   value
     d  tet_optlist                        value like(r_optlist_u)

     d TET_open_...
     d page            pr            10i 0 extproc('RTET_OPEN_PAGE')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_page                     10i 0 value
     d  tet_optlist                        value like(r_optlist_u)

     d TET_pcos_...
     d get_number      pr             8f   extproc('RTET_PCOS_GET_NUMBER')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_path                           value like(r_filename_u)
     d  tet_addprm                   10i 0 value options(*nopass)

     d TET_pcos_...
     d get_string      pr                  like(r_text_long_u)
     d                                     extproc('RTET_PCOS_GET_STRING')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_path                           value like(r_path_u)

     d TET_pcos_...
     d get_stream      pr              *
     d                                     extproc('RTET_PCOS_GET_STREAM')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_len                      10i 0
     d  tet_optlist                        value like(r_optlist_u)
     d  tet_path                           value like(r_path_u)

     d TET_set_...
     d option          pr
     d                                     extproc('RTET_SET_OPTION')
     d  tet                            *   value
     d  tet_optlist                        value like(r_optlist_u)

     d TET_write_...
     d image_file      pr            10i 0
     d                                     extproc('RTET_WRITE_IMAGE_FILE')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_imgid                    10i 0 value
     d  tet_optlist                        value like(r_optlist_u)

     d TET_process_...
     d page            pr            10i 0
     d                                     extproc('RTET_PROCESS_PAGE')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_page                     10i 0 value
     d  tet_optlist                        value like(r_optlist_u)

     d TET_image_info  ds                  based(TET_image_info_p)
     d  img_x                         8f                                        x position of the image's reference poin
     d  img_y                         8f                                        y position of the image's reference poin
     d  img_width                     8f                                        width and height of the image on the pag
     d  img_height                    8f                                        in points, measured along the edges
     d  img_alpha                     8f                                        direction of the pixel rows (in degrees)
     d  img_beta                      8f                                        direction of columns, relative to the
     d                                                                          perpendicular of alpha
     d  img_id                       10i 0                                      Image ID
     d  attributes                   10i 0                                      Attributes

     d TET_char_info   ds                  based(tet_char_info_p)
     d ci_uv                         10u 0                                      current character in UTF-32
     d ci_type                       10i 0                                      character type, see TET_CT_* above
     d ci_unknown                    10i 0                                      1 if glyph couldn't be mapped to Unicode
     d ci_attributes                 10i 0                                      character attributes, see TET_ATTR_* con
     d ci_x                           8f                                        x position of the char's reference point
     d ci_y                           8f                                        y position of the char's reference point
     d ci_width                       8f                                        horizontal character extent
     d ci_height                      8f                                        vertical character extent
     d ci_alpha                       8f                                        text baseline angle in degrees
     d ci_beta                        8f                                        vertical character slanting angle
     d ci_fontid                     10i 0                                      pCOS font id
      * added because of padding (int 4-Byte before double 8-Byte)
     d ci_padding01                  10i 0                                      Because of padding
     d ci_fontsize                    8f                                        size of the font
     d ci_colorid                    10i 0                                      unique text color id
     d ci_textrender                 10i 0                                      text rendering mode, see TET_TR_* above

     d TET_COL_MAXCOMP...
     d                 c                   const(8)                             maximum number of color components

     d TET_color_info  ds                  Qualified based(Empty)
     d colorspaceid...
     d                               10i 0                                      colorspace id or -1
     d patternid                     10i 0                                      pattern id or -1
     d components                     8f   dim(TET_COL_MAXCOMP)                 color components   d
     d n                             10i 0                                      number of relevant entries in

     d pcos_ot_null    c                   0
     d pcos_ot_...
     d boolean         c                   1
     d pcos_ot_number  c                   2
     d pcos_ot_name    c                   3
     d pcos_ot_string  c                   4
     d pcos_ot_array   c                   5
     d pcos_ot_dict    c                   6
     d pcos_ot_stream  c                   7
     d pcos_ot_...
     d fstream         c                   8

     d pcos_mode_...
     d minimum         c                   0                                    encrypted doc (opened w/o password)
     d pcos_mode_...
     d restricted      c                   1                                    encrypted doc (opened w/ user password)
     d pcos_mode_...
     d full            c                   2                                    unencrypted doc or opened w/ master pass

      * Image formats returned by TET_write_image_file()
     d tet_if_tiff     c                   10
     d tet_if_jpeg     c                   20
     d tet_if_jp2      c                   31
     d tet_if_jpf      c                   32
     d tet_if_j2k      c                   33
     d tet_if_jbig2    c                   50

      * TET_char_info character types with real geometry info.
     d TET_CT_NORMAL...
     d                 c                   0
     d TET_CT_SEQ_START...
     d                 c                   1

      * TET_char_info character types with artificial geometry info.
     d TET_CT_SEQ_CONT...
     d                 c                   10
     d TET_CT_INSERTED...
     d                 c                   12

      * TET_char_info text rendering modes.
     d TET_TR_FILL...                                                           fill text
     d                 c                   0
     d TET_TR_STROKE...                                                         stroke text (outline)
     d                 c                   1
     d TET_TR_FILLSTROKE...                                                     fill and stroke text
     d                 c                   2
     d TET_TR_INVISIBLE...                                                      invisible text
     d                 c                   3
     d TET_TR_FILL_CLIP...                                                      fill text and
     d                 c                   4                                    add it to the clipping path
     d TET_TR_STROKE_CLIP...                                                    stroke text and
     d                 c                   5                                    add it to the clipping path
     d TET_TR_FILLSTROKE_CLIP...                                                fill and stroke text and
     d                 c                   6                                    add it to the clipping path
     d TET_TR_CLIP...                                                           add text to the clipping path
     d                 c                   7

      *  TET_char_info attributes
     d TET_ATTR_NONE...
     d                 c                   0
     d TET_ATTR_SUB...                                                          subscript
     d                 c                   1
     d TET_ATTR_SUP...                                                          superscript
     d                 c                   2
     d TET_ATTR_DROPCAP...                                                      initial large letter
     d                 c                   4
     d TET_ATTR_SHADOW...                                                       shadowed text
     d                 c                   8
     d TET_ATTR_DEHYPHENATION_PRE...                                            character before hyphenation
     d                 c                   16
     d TET_ATTR_DEHYPHENATION_ARTIFACT...                                       hyphenation artifact, i.e. the dash
     d                 c                   32
     d TET_ATTR_DEHYPHENATION_POST...                                           character after hyphenation
     d                 c                   64
     d TET_ATTR_ARTIFACT...                                                     Text or image marked as Artifact (irrelevant content) in Tagged PDF
     d                 c                   256

     d/endif


