      **************************************************************************
      *       Copyright (c) 2005-2022 PDFlib GmbH. All rights reserved.        *
      **************************************************************************
      * This software may not be copied or distributed except as expressly     *
      * authorized by PDFlib GmbH's general license agreement or a custom      *
      * license agreement signed by PDFlib GmbH.                               *
      * For more information about licensing please refer to www.pdflib.com.   *
      **************************************************************************

      **************************************************************************
      *  TETlib Constants and Prototypes for ILE RPG to call c functions       *
      **************************************************************************

     d TET_close_...
     d document        pr                  extproc('TET_close_document')
     d  tet                            *   value
     d  tet_doc                      10i 0 value

     d TET_...
     d close_page      pr                  extproc('TET_close_page')
     d  tet                            *   value
     d  tet_page                     10i 0 value

     d TET_...
     d create_pvf      pr                  extproc('TET_create_pvf')
     d  tet                            *   value
     d  tet_filename                   *   value OPTIONS(*STRING)
     d  tet_len                      10i 0 value
     d  tet_data                       *   value
     d  tet_datalen                  10i 0 value
     d  tet_optlist                    *   value OPTIONS(*STRING)

     d TET_delete      pr                  extproc('TET_delete')
     d  tet                            *   value

     d TET_...
     d delete_pvf      pr                  extproc('TET_delete_pvf')
     d  tet                            *   value
     d  tet_filename                   *   value OPTIONS(*STRING)
     d  tet_len                      10i 0 value

     d TET_info_pvf...
     d                 pr             8f   extproc('TET_info_pvf')
     d  tet                            *   value
     d  filename                       *   value OPTIONS(*STRING)
     d  len                          10i 0 value
     d  keyword                        *   value OPTIONS(*STRING)


     d TET_convert_to_unicode...
     d                 pr              *   extproc('TET_convert_to_unicode')
     d  tet                            *   value
     d  inputformat                    *   value OPTIONS(*STRING)
     d  inputstring                    *   value OPTIONS(*STRING)
     d  inputlen                     10i 0 value
     d  outputlen                    10i 0
     d  optlist                        *   value OPTIONS(*STRING)


     d TET_get_...
     d apiname         pr              *
     d                                     extproc('TET_get_apiname')
     d  tet                            *   value

     d TET_get_...
     d char_info       pr              *   extproc('TET_get_char_info')
     d  tet                            *   value
     d  tet_page                     10i 0 value

     d TET_...
     d get_errmsg      pr              *   extproc('TET_get_errmsg')
     d  tet                            *   value

     d TET_...
     d get_errnum      pr            10i 0 extproc('TET_get_errnum')
     d  tet                            *   value

     d TET_get_image_...
     d data            pr              *
     d                                     extproc('TET_get_image_data')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_len                      10i 0
     d  tet_imgid                    10i 0 value
     d  tet_optlist                    *   value OPTIONS(*STRING)

     d TET_...
     d get_image_...
     d info            pr              *   extproc('TET_get_image_info')
     d  tet                            *   value
     d  tet_page                     10i 0 value

     d TET_get_...
     d text            pr              *   extproc('TET_get_text')
     d  tet                            *   value
     d  tet_page                     10i 0 value
     d  tet_len                      10i 0

     d TET_new         pr              *   extproc('TET_new')

     d TET_open_...
     d document        pr            10i 0 extproc('TET_open_document')
     d  tet                            *   value
     d  tet_filename                   *   value OPTIONS(*STRING)
     d  tet_len                      10i 0 value
     d  tet_optlist                    *   value OPTIONS(*STRING)

     d TET_open_...
     d document_...
     d callback        pr            10i 0 extproc('TET_open_document_-
     d                                     callback')
     d  tet                            *   value
     d  opaque                         *   value
     d  filesize                     10i 0 value
     d  readproc                       *   value
     d  seekproc                       *   value
     d  tet_optlist                    *   value OPTIONS(*STRING)

     d TET_open_...
     d page            pr            10i 0 extproc('TET_open_page')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_page                     10i 0 value
     d  tet_optlist                    *   value OPTIONS(*STRING)

     d TET_pcos_...
     d get_number      pr             8f   extproc('TET_pcos_get_number')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_path                       *   value OPTIONS(*STRING)
     d  tet_addprm                   10i 0 value options(*nopass)

     d TET_pcos_...
     d get_string      pr              *
     d                                     extproc('TET_pcos_get_string')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_path                       *   value OPTIONS(*STRING)
     d  tet_addprm                   10i 0 value options(*nopass)

     d TET_pcos_...
     d get_stream      pr              *   extproc('TET_pcos_get_stream')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_len                      10i 0
     d  tet_optlist                    *   value OPTIONS(*STRING)
     d  tet_path                       *   value OPTIONS(*STRING)
     d  tet_addprm                   10i 0 value options(*nopass)

     d TET_set_...
     d option          pr                  extproc('TET_set_option')
     d  tet                            *   value
     d  tet_optlist                    *   value OPTIONS(*STRING)

     d TET_write_...
     d image_file      pr            10i 0
     d                                     extproc('TET_write_image_file')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_imgid                    10i 0 value
     d  tet_optlist                    *   value OPTIONS(*STRING)

     d TET_process_...
     d page            pr            10i 0 extproc('TET_process_page')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_page                     10i 0 value
     d  tet_optlist                    *   value OPTIONS(*STRING)

     d TET_get_...
     d tetml           pr              *   extproc('TET_get_tetml')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_len                      10i 0
     d  tet_optlist                    *   value OPTIONS(*STRING)

     d TET_image_info  ds                  based(TET_image_info_p)
     d  img_x                         8f                                        x position of the image's reference poin
     d  img_y                         8f                                        y position of the image's reference poin
     d  img_width                     8f                                        width and height of the image on the pag
     d  img_height                    8f                                        in points, measured along the edges
     d  img_alpha                     8f                                        direction of the pixel rows (in degrees)
     d  img_beta                      8f                                        direction of columns, relative to the
     d                                                                          perpendicular of alpha
     d  img_id                       10i 0                                      Image ID

     d TET_char_info   ds                  based(tet_char_info_p)
     d ci_uv                         10u 0                                      current character in UTF-32
     d ci_type                       10i 0                                      character type, see TET_CT_* above
     d ci_unknown                    10i 0                                      1 if glyph couldn't be mapped to Unicode
     d ci_attributes                 10i 0                                      character attributes, see TET_ATTR_* con
     d ci_x                           8f                                        x position of the char's reference point
     d ci_y                           8f                                        y position of the char's reference point
     d ci_width                       8f                                        horizontal character extent
     d ci_alpha                       8f                                        text baseline angle in degrees
     d ci_beta                        8f                                        vertical character slanting angle
     d ci_fontid                     10i 0                                      pCOS font id
     d ci_filler2                    10i 0                                      Filler
     d ci_fontsize                    8f                                        size of the font
     d ci_textrender                 10i 0                                      text rendering mode, see TET_TR_* above

     d pcos_ot_null    c                   0
     d pcos_ot_...
     d boolean         c                   1
     d pcos_ot_number  c                   2
     d pcos_ot_name    c                   3
     d pcos_ot_string  c                   4
     d pcos_ot_array   c                   5
     d pcos_ot_dict    c                   6
     d pcos_ot_stream  c                   7
     d pcos_ot_...
     d fstream         c                   8

     d pcos_mode_...
     d minimum         c                   0                                    encrypted doc (opened w/o password)
     d pcos_mode_...
     d restricted      c                   1                                    encrypted doc (opened w/ user password)
     d pcos_mode_...
     d full            c                   2                                    unencrypted doc or opened w/ master pass

      * Image formats returned by TET_write_image_file()
     d tet_if_tiff     c                   10
     d tet_if_jpeg     c                   20
     d tet_if_jp2      c                   31
     d tet_if_jpf      c                   32
     d tet_if_j2k      c                   33
     d tet_if_jbig2    c                   50

      * TET_char_info character types with real geometry info.
     d TET_CT_NORMAL...
     d                 c                   0
     d TET_CT_SEQ_START...
     d                 c                   1

      * TET_char_info character types with artificial geometry info.
     d TET_CT_SEQ_CONT...
     d                 c                   10
     d TET_CT_INSERTED...
     d                 c                   12

      * TET_char_info text rendering modes.
     d TET_TR_FILL...                                                           fill text
     d                 c                   0
     d TET_TR_STROKE...                                                         stroke text (outline)
     d                 c                   1
     d TET_TR_FILLSTROKE...                                                     fill and stroke text
     d                 c                   2
     d TET_TR_INVISIBLE...                                                      invisible text
     d                 c                   3
     d TET_TR_FILL_CLIP...                                                      fill text and
     d                 c                   4                                    add it to the clipping path
     d TET_TR_STROKE_CLIP...                                                    stroke text and
     d                 c                   5                                    add it to the clipping path
     d TET_TR_FILLSTROKE_CLIP...                                                fill and stroke text and
     d                 c                   6                                    add it to the clipping path
     d TET_TR_CLIP...                                                           add text to the clipping path
     d                 c                   7

      *  TET_char_info attributes
     d TET_ATTR_NONE...
     d                 c                   0
     d TET_ATTR_SUB...                                                          subscript
     d                 c                   1
     d TET_ATTR_SUP...                                                          superscript
     d                 c                   2
     d TET_ATTR_DROPCAP...                                                      initial large letter
     d                 c                   4
     d TET_ATTR_SHADOW...                                                       shadowed text
     d                 c                   8
     d TET_ATTR_DEHYPHENATION_PRE...                                            character before hyphenation
     d                 c                   16
     d TET_ATTR_DEHYPHENATION_ARTIFACT...                                       hyphenation artifact, i.e. the dash
     d                 c                   32
     d TET_ATTR_DEHYPHENATION_POST...                                           character after hyphenation
     d                 c                   64
     d TET_ATTR_ARTIFACT...                                                     Text or image marked as Artifact (irrelevant content) in Tagged PDF
     d                 c                   128
