      **************************************************************************
      *       Copyright (c) 2005-2022 PDFlib GmbH. All rights reserved.        *
      **************************************************************************
      * This software may not be copied or distributed except as expressly     *
      * authorized by PDFlib GmbH's general license agreement or a custom      *
      * license agreement signed by PDFlib GmbH.                               *
      * For more information about licensing please refer to www.pdflib.com.   *
      **************************************************************************

     h nomain
     H COPYRIGHT('(c) PDFlib GmbH (www.pdflib.com)')
      *********************************************************************************************
      *   RPG Wrapper Functions
      *********************************************************************************************
      *
      *********************************************************************************************
      *
     d/define NO_RPG_PROTOTYPES
      *
     d/copy TETLIB.RPGLE

     d TET_new         pr              *   extproc('TET_new')

     d tet_rpg_close_document...
     d                 pr            10i 0 extproc('tet_rpg_close_document')
     d  tet                            *   value
     d  tet_doc                      10i 0 value

     d tet_rpg_close_page...
     d                 pr            10i 0 extproc('tet_rpg_close_page')
     d  tet                            *   value
     d  tet_page                     10i 0 value

     d tet_rpg_create_pvf...
     d                 pr                  extproc('tet_rpg_create_pvf')
     d  tet                            *   value
     d  tet_file                  32767a   options(*varsize)
     d  tet_filelen                  10i 0 value
     d  tet_data                       *   value
     d  tet_datalen                  10i 0 value
     d  tet_optlist               32767a   options(*varsize)
	
     d tet_rpg_info_pvf...
     d                 pr             8f   extproc('tet_rpg_info_pvf')
     d  tet                            *   value
     d  tet_filename                   *   value OPTIONS(*STRING)
     d  tet_len                      10i 0 value
     d  tet_keyword                    *   value OPTIONS(*STRING)
	
     d tet_rpg_delete_pvf...
     d                 pr                  extproc('tet_rpg_delete_pvf')
     d  tet                            *   value
     d  tet_file                  32767a   options(*varsize)
     d  tet_reserve                  10i 0 value

     d tet_rpg_convert_to_unicode...
     d                 pr              *   extproc('tet_rpg_convert_to_unicode')
     d  tet                            *   value
     d  inputformat                        like(r_text_long_s) options(*varsize)
     d  inputstring                        like(r_text_long_s) options(*varsize)
     d  inputlen                     10i 0 value
     d  outputlen                    10i 0
     d  optlist                            like(r_text_long_s) options(*varsize)

     d tet_rpg_get_apiname...
     d                 pr              *   extproc('tet_rpg_get_apiname')
     d  tet                            *   value

     d tet_rpg_get_char_info...
     d                 pr              *   extproc('tet_rpg_get_char_info')
     d  tet                            *   value
     d  tet_page                     10i 0 value

     d tet_rpg_get_color_info...
     d                 pr              *   extproc('tet_rpg_get_color_info')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_color                    10i 0 value
     d  tet_optlist                        value like(r_optlist_u)

     d tet_rpg_get_errmsg...
     d                 pr              *   extproc('tet_rpg_get_errmsg')
     d  tet                            *   value

     d tet_rpg_get_errnum...
     d                 pr            10i 0 extproc('tet_rpg_get_errnum')
     d  tet                            *   value

     d tet_rpg_get_image_data...
     d                 pr              *   extproc('tet_rpg_get_image_data')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_len                      10i 0
     d  tet_imgid                    10i 0 value
     d  tet_optlist               32767a   options(*varsize)

     d tet_rpg_get_image_info...
     d                 pr              *   extproc('tet_rpg_get_image_info')
     d  tet                            *   value
     d  tet_page                     10i 0 value

     d tet_rpg_get_text...
     d                 pr              *   extproc('tet_rpg_get_text')
     d  tet                            *   value
     d  tet_page                     10i 0 value
     d  tet_len                      10i 0

     d tet_rpg_open_document...
     d                 pr            10i 0 extproc('tet_rpg_open_document')
     d  tet                            *   value
     d  tet_filename              32767    options(*varsize)
     d  tet_len                      10i 0 value
     d  tet_optlist               32767    options(*varsize)

     d tet_rpg_open_document_callback...
     d                 pr            10i 0 extproc('tet_rpg_-
     d                                     open_document_callback')
     d  tet                            *   value
     d  opaque                         *   value
     d  filesize                     10i 0 value
     d  readproc                       *   value
     d  seekproc                       *   value
     d  optlist                   32767    options(*varsize)

     d tet_rpg_open_page...
     d                 pr            10i 0 extproc('tet_rpg_open_page')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_page                     10i 0 value
     d  tet_optlist               32767    options(*varsize)

     d tet_rpg_pcos_get_number...
     d                 pr             8f   extproc('tet_rpg_pcos_get_number')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_path                  32767    options(*varsize)
     d  tet_addprm                   10i 0 value options(*nopass)

     d tet_rpg_pcos_get_string...
     d                 pr              *   extproc('tet_rpg_pcos_get_string')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_path                  32767    options(*varsize)

     d tet_rpg_pcos_get_stream...
     d                 pr              *   extproc('tet_rpg_pcos_get_stream')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_len                      10i 0
     d  tet_optlist               32767    options(*varsize)
     d  tet_path                  32767    options(*varsize)

     d tet_rpg_set_option...
     d                 pr                  extproc('tet_rpg_set_option')
     d  tet                            *   value
     d  optlist                   32767    options(*varsize)

     d tet_rpg_write_image_file...
     d                 pr            10i 0 extproc('tet_rpg_write_image_file')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_imgid                    10i 0 value
     d  tet_optlist               32767    options(*varsize)

     d tet_rpg_process_page...
     d                 pr            10i 0 extproc('tet_rpg_process_page')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_page                     10i 0 value
     d  tet_optlist               32767    options(*varsize)

     d tet_rpg_get_tetml...
     d                 pr              *   extproc('tet_rpg_get_tetml')
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_len                      10i 0
     d  tet_optlist               32767    options(*varsize)

     d RTET_...
     d create_pvf      pr
     d  tet                            *   value
     d  tet_filename                       value like(r_filename_u)
     d  tet_data                       *   value
     d  tet_datalen                  10i 0 value
     d  tet_optlist                        value like(r_optlist_u)

     d RTET_...
     d delete_pvf      pr
     d  tet                            *   value
     d  tet_filename                       value like(r_filename_u)

     d RTET_get_...
     d apiname         pr          1024c   varying
     d  tet                            *   value

     d RTET_get_...
     d char_info       pr              *
     d  tet                            *   value
     d  tet_page                     10i 0 value

     d RTET_get_color_info...
     d                 pr              *
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_color                    10i 0 value
     d  tet_optlist                        value like(r_optlist_u)

     d RTET_...
     d get_errmsg      pr          1024c   varying
     d  tet                            *   value

     d RTET_...
     d get_errnum      pr            10i 0
     d  tet                            *   value

     d RTET_get_image_...
     d data            pr              *
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_len                      10i 0
     d  tet_imgid                    10i 0 value
     d  tet_optlist                        value like(r_optlist_u)

     d RTET_...
     d get_image_...
     d info            pr              *
     d  tet                            *   value
     d  tet_page                     10i 0 value

     d RTET_get_...
     d text            pr              *
     d  tet                            *   value
     d  tet_page                     10i 0 value
     d  tet_len                      10i 0

     d RTET_new        pr              *

     d RTET_open_...
     d document        pr            10i 0
     d  tet                            *   value
     d  tet_filename                       value like(r_filename_u)
     d  tet_optlist                        value like(r_optlist_u)

     d RTET_open_...
     d document_...
     d callback        pr            10i 0
     d  tet                            *   value
     d  opaque                         *   value
     d  filesize                     10i 0 value
     d  readproc                       *   value
     d  seekproc                       *   value
     d  tet_optlist                        value like(r_optlist_u)

     d RTET_open_...
     d page            pr            10i 0
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_page                     10i 0 value
     d  tet_optlist                        value like(r_optlist_u)

     d RTET_pcos_...
     d get_number      pr             8f
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_path                           value like(r_filename_u)
     d  tet_addprm                   10i 0 value options(*nopass)

     d RTET_pcos_...
     d get_string      pr          1024c   varying
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_path                           value like(r_path_u)

     d RTET_pcos_...
     d get_stream      pr              *
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_len                      10i 0
     d  tet_optlist                        value like(r_optlist_u)
     d  tet_path                           value like(r_path_u)

     d RTET_set_...
     d option          pr
     d  tet                            *   value
     d  tet_optlist                        value like(r_optlist_u)

     d RTET_write_...
     d image_file      pr            10i 0
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_imgid                    10i 0 value
     d  tet_optlist                        value like(r_optlist_u)

     d RTET_convert_to_unicode...
     d                 pr              *
     d  tet                            *   value
     d  inputformat                        value like(r_text_u)
     d  inputstring               32767    options(*varsize)
     d  inputlen                     10i 0 value
     d  outputlen                    10i 0
     d  optlist                            value like(r_optlist_u)

     d RTET_process_...
     d page            pr            10i 0
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_page                     10i 0 value
     d  tet_optlist                        value like(r_optlist_u)

     d RTET_get_...
     d tetml           pr              *
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_len                      10i 0
     d  tet_optlist                        value like(r_optlist_u)

     d RTET_get_xml_...
     d data            pr              *
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_len                      10i 0
     d  tet_optlist                        value like(r_optlist_u)
      *
     d RTET_close_document...
     d                 pr            10i 0
     d  tet                            *   value
     d  tet_doc                      10i 0 value
      *
     d RTET_close_page...
     d                 pr            10i 0
     d  tet                            *   value
     d  tet_page                     10i 0 value

     d RTET_info_pvf...
     d                 pr             8f
     d  tet                            *   value
     d  filename                           value like(r_filename_u)
     d  keyword                            value like(r_optlist_u)
	
      *
     d uc2sb           pr          2048    varying
     d  tet                            *   value
     d  uc                                 value like(r_text_u)

     d ascii2ebcdic...
     d _len            pr                  extproc('pdc_ascii2ebcdic_len')
     d  ascii                     32767    options(*varsize)
     d  len                          10i 0 value

      *  Test Bit in string
     d tstbts          PR            10u 0 extproc('_TSTBTS')
     d  string                    32767a   options(*varsize)
     d  bit                          10u 0 value

      *  Clear Bit in string
     d clrbts          PR                  extproc('_CLRBTS')
     d  string                    32767a   options(*varsize)
     d  bit                          10u 0 value

      *  Set Bit in string
     d setbts          PR                  extproc('_SETBTS')
     d  string                    32767a   options(*varsize)
     d  bit                          10u 0 value
      ***********************************************************************************************************
      *   Translate unicode string to single byte string
      *
     p uc2sb           b
     d uc2sb           pi          2048    varying
     d  tet                            *   value
     d  uc                                 value like(r_text_u)

     d rtn_d           s                   like(r_text_long_s) based(rtn_p)
     d rtnlen          s             10i 0
     d inplen          s             10i 0
     d uc_data_adr     s               *
     d uc_data         s          32767    based(uc_data_adr)
     d inputformat0    s             +1    like(r_text)
     d optlist0        s             +1    like(r_optlist)
      *
      /free
          inputformat0 = 'utf16' + x'00';
          inplen = %len(uc);
          uc_data_adr = %addr(uc) + 2;
          optlist0 = 'outputformat=ebcdicutf8' + x'00';

          rtn_p = tet_rpg_convert_to_unicode(
                        tet :
                        inputformat0 :
                        uc_data :
                        %len(uc) * 2 :
                        rtnlen :
                        optlist0 );
          if rtnlen = 0;
            return '';
          else;
            return %subst(rtn_d:1:rtnlen);
          ENDIF;
      /end-free
     p uc2sb           e
      *********************************************************************************************
      * RTET_create_pvf
      *
     p RTET_...
     p create_pvf      b                   export
      *
     d RTET_...
     d create_pvf      pi
     d  tet                            *   value
     d  filename                           value like(r_filename_u)
     d  data                           *   value
     d  datalen                      10i 0 value
     d  optlist                            value like(r_optlist_u)
      *
     d data_sb         s              1    based(data)
     d filename_sb     s              1    based(filename_p)
     d optlist0        s             +1    like(r_optlist)
     d len             s             10i 0
      *
     c                   eval      len=%len(filename)*2
     c                   eval      filename_p=%addr(filename)+2
     c                   if        len=0
     c                   eval      filename_sb=x'00'
     c                   endif
     c                   eval      optlist0=uc2sb(tet:optlist)+x'00'
      *
     c                   callp     tet_rpg_create_pvf(tet:filename_sb:len:
     c                                         data:datalen:optlist0)
     c                   return
      *
     p RTET_...
     p create_pvf      e
      *********************************************************************************************
      * RTET_info_pvf
      *
     p RTET_info_pvf...
     p                 b                   export
      *
	
     d RTET_info_pvf...
     d                 pi             8f
     d  tet                            *   value
     d  filename                           value like(r_filename_u)
     d  keyword                            value like(r_optlist_u)
      *
     d filename_sb     s              1    based(filename_p)
     d keyword_l       s                   like(r_text_long_u)
     d keyword0        s             +1    like(r_optlist)
     d len             s             10i 0
      *
     c                   eval      len=%len(filename)*2
     c                   eval      filename_p=%addr(filename)+2
     c                   if        len=0
     c                   eval      filename_sb=x'00'
     c                   endif

     c                   eval      keyword_l = keyword
     c                   eval      keyword0 = uc2sb(tet:keyword_l) + x'00'
      *
     c                   return    tet_rpg_info_pvf(tet:filename_sb:len:
     c                                         keyword0)
      *
     p RTET_info_pvf...
     p                 e
      *********************************************************************************************
      * RTET_delete_pvf
      *
     p RTET_...
     p delete_pvf      b                   export
      *
     d RTET_...
     d delete_pvf      pi
     d  tet                            *   value
     d  filename                           value like(r_filename_u)
      *
     d filename_sb     s              1    based(filename_p)
     d len             s             10i 0
      *
     c                   eval      len=%len(filename)*2
     c                   eval      filename_p=%addr(filename)+2
     c                   if        len=0
     c                   eval      filename_sb=x'00'
     c                   endif

     c                   callp     tet_rpg_delete_pvf(tet:filename_sb:len)
     c                   return

     p RTET_...
     p delete_pvf      e
      ***********************************************************************************************************
     p RTET_get_...
     p apiname         b                   export

     d RTET_get_...
     d apiname         pi          1024c   varying
     d  tet                            *   value
      *
     d value           s          32767    based(value_p)
      /free
          value_p = tet_rpg_get_apiname(tet);
          if value_p <> *NULL;
            return %ucs2(%subst(value:1:%scan(x'00':value)-1));

          else;
            return %ucs2('');

          endif;

      /end-free
     p RTET_get_...
     p apiname         e
      ***********************************************************************************************************
     p RTET_get_...
     p errmsg          b                   export

     d RTET_get_...
     d errmsg          pi          1024c   varying
     d  tet                            *   value

     d value           s          32767    based(value_p)
      /free
          value_p = tet_rpg_get_errmsg(tet);

          if value_p <> *NULL;
            return %ucs2(%subst(value:1:%scan(x'00':value)-1));

          else;
            return %ucs2('');
          endif;

      /end-free
     p RTET_get_...
     p errmsg          e

*********************************************************************************************
     p RTET_...
     p get_image_...
     p data            b                   export

     d RTET_...
     d get_image_...
     d data            pi              *
     d  tet                            *   value
     d  doc                          10i 0 value
     d  len                          10i 0
     d  imgid                        10i 0 value
     d  optlist                            value like(r_optlist_u)

     d optlist0        s             +1    like(r_optlist)
     d optlist_l       s                   like(r_text_long_u)
     c                   eval      optlist_l = optlist
     c                   eval      optlist0=uc2sb(tet:optlist_l)+x'00'

     c                   return    tet_rpg_get_image_data
     c                                   (tet:doc:len:imgid:optlist0)

     p RTET_...
     p get_image_...
     p data            e
      *********************************************************************************************
     pRTET_new         b                   export
      *
     dRTET_new         pi              *
      *
     d tet             s               *
     d option          s            200

     c                   eval      tet=tet_new
     c                   if        tet=*null
     c                   return    *null
     c                   endif
      *  do settings for rpg wrapper
     c                   eval      option='binding=RPG unicaplang ' +
     c                                    'outputformat=utf8' + x'00'
     c                   callp     tet_rpg_set_option(tet:option)
     c                   return    tet

     pRTET_new         e
      *********************************************************************************************
     p RTET_open_...
     p document        b                   export

     d RTET_open_...
     d document        pi            10i 0
     d  tet                            *   value
     d  filename                           value like(r_filename_u)
     d  tet_optlist                        value like(r_optlist_u)

     d filename_sb     s              1    based(filename_p)
     d optlist0        s             +1    like(r_optlist)
     d len             s             10i 0
     d tet_optlist_l   s                   like(r_text_long_u)

     c                   eval      len=%len(filename)*2
     c                   eval      filename_p=%addr(filename)+2
     c                   eval      tet_optlist_l = tet_optlist
     c                   eval      optlist0=uc2sb(tet:tet_optlist_l)+x'00'

     c                   return    tet_rpg_open_document(tet:filename_sb:len:
     c                                                     optlist0)

     p RTET_open_...
     p document        e
      ***********************************************************************************************************
     p RTET_open_...
     p document_...
     p callback        b                   export
      *
     d RTET_open_...
     d document_...
     d callback        pi            10i 0
     d  tet                            *   value
     d  opaque                         *   value
     d  filesize                     10i 0 value
     d  readproc                       *   value
     d  seekproc                       *   value
     d  tet_optlist                        value like(r_optlist_u)

     d optlist0        s             +1    like(r_optlist)
     d tet_optlist_l   s                   like(r_text_long_u)

     c                   eval      tet_optlist_l = tet_optlist
     c                   eval      optlist0=uc2sb(tet:tet_optlist_l)+x'00'

     c                   return    tet_rpg_open_document_callback(tet:opaque:
     c                                    filesize:readproc:seekproc:optlist0)

     p RTET_open_...
     p document_...
     p callback        e
      ***********************************************************************************************************
     p RTET_open_...
     p page            b                   export

     d RTET_open_...
     d page            pi            10i 0
     d  tet                            *   value
     d  doc                          10i 0 value
     d  pageno                       10i 0 value
     d  tet_optlist                        value like(r_optlist_u)

     d optlist0        s             +1    like(r_optlist)
     d tet_optlist_l   s                   like(r_text_long_u)

     c                   eval      tet_optlist_l = tet_optlist
     c                   eval      optlist0=uc2sb(tet:tet_optlist_l)+x'00'
     c                   return    tet_rpg_open_page(tet:doc:pageno:optlist0)

     p RTET_open_...
     p page            e
      ***********************************************************************************************************
     p RTET_pcos_...
     p get_number      b                   export

     d RTET_pcos_...
     d get_number      pi             8f
     d  tet                            *   value
     d  doc                          10i 0 value
     d  tet_path                           value like(r_path_u)
     d  addprm                       10i 0 value options(*nopass)
      *
     d path0           s             +1    like(r_path)
     d tet_path_l      s                   like(r_text_long_u)

     c                   eval      tet_path_l = tet_path
     c                   eval      path0=uc2sb(tet:tet_path_l)+x'00'
      *
     c                   if        %parms>3
     c                   return    tet_rpg_pcos_get_number(tet:doc:path0:addprm)
     c                   else
     c                   return    tet_rpg_pcos_get_number(tet:doc:path0)
     c                   endif

     p RTET_pcos_...
     p get_number      e
      ***********************************************************************************************************
     p RTET_pcos_...
     p get_string      b                   export

     d RTET_pcos_...
     d get_string      pi          1024c   varying
     d  tet                            *   value
     d  doc                          10i 0 value
     d  tet_path                           value like(r_path_u)

     d path0           s             +1    like(r_path)
     d uc_l            s                   like(r_text_long_u)
     d value           s                   based(value_p) like(r_text_long_s)
     d inputformat0    s             +1    like(r_text)
     d optlist0        s             +1    like(r_optlist)
     d rtnlen          s             10i 0
     d rtn_u           s          16383c   based(rtn_p)
      /free
          uc_l = tet_path;
          path0 = uc2sb(tet : uc_l) + x'00';
          value_p = tet_rpg_pcos_get_string(tet : doc : path0);
          uc_l = %ucs2('ebcdicutf8');
          inputformat0 = uc2sb(tet : uc_l) + x'00';
          uc_l = %ucs2('outputformat=utf16');
          optlist0 = uc2sb(tet : uc_l) + x'00';

          rtn_p = tet_rpg_convert_to_unicode(
                        tet :
                        inputformat0 :
                        value :
                        %len(%str(value_p)) :
                        rtnlen :
                        optlist0 );
          uc_l = %subst(rtn_u : 1 : %int(rtnlen / 2));
          return uc_l;
      /end-free
     p RTET_pcos_...
     p get_string      e
      ***********************************************************************************************************
     p RTET_pcos_...
     p get_stream      b                   export

     d RTET_pcos_...
     d get_stream      pi              *
     d  tet                            *   value
     d  doc                          10i 0 value
     d  len                          10i 0
     d  tet_optlist                        value like(r_optlist_u)
     d  tet_path                           value like(r_path_u)
      *
     d optlist0        s             +1    like(r_optlist)
     d uc_l            s                   like(r_text_long_u)
     d path0           s             +1    like(r_path)
      *
     c                   eval      uc_l = tet_optlist
     c                   eval      optlist0 = uc2sb(tet : uc_l) + x'00'
     c                   eval      uc_l = tet_path
     c                   eval      path0 = uc2sb(tet : uc_l) + x'00'
      *
     c                   return    tet_rpg_pcos_get_stream(tet:doc:len:
     c                                                  optlist0:path0)
      *
     p RTET_pcos_...
     p get_stream      e
      ***********************************************************************************************************
     p RTET_set_...
     p option          b                   export
      *
     d RTET_set_...
     d option          pi
     d  tet                            *   value
     d  tet_optlist                        value like(r_optlist_u)

     d optlist0        s             +1    like(r_optlist)
     d uc_l            s                   like(r_text_long_u)

     c                   eval      uc_l = tet_optlist
     c                   eval      optlist0 = uc2sb(tet : uc_l) + x'00'
     c                   callp     tet_rpg_set_option(tet:optlist0)
     c                   return

     p RTET_set_...
     p option          e
      ***********************************************************************************************************
     p RTET_write_...
     p image_file      b                   export
      *
     d RTET_write_...
     d image_file      pi            10i 0
     d  tet                            *   value
     d  doc                          10i 0 value
     d  imgid                        10i 0 value
     d  tet_optlist                        value like(r_optlist_u)

     d optlist0        s             +1    like(r_optlist)
     d uc_l            s                   like(r_text_long_u)

     c                   eval      uc_l = tet_optlist
     c                   eval      optlist0 = uc2sb(tet : uc_l) + x'00'
     c                   return    tet_rpg_write_image_file
     c                                              (tet:doc:imgid:optlist0)

     p RTET_write_...
     p image_file      e
      ***********************************************************************************************************
     p RTET_process_...
     p page            b                   export
      *
     d RTET_process_...
     d page            pi            10i 0
     d  tet                            *   value
     d  doc                          10i 0 value
     d  pagno                        10i 0 value
     d  tet_optlist                        value like(r_optlist_u)

     d optlist0        s             +1    like(r_optlist)
     d uc_l            s                   like(r_text_long_u)

     c                   eval      uc_l = tet_optlist
     c                   eval      optlist0 = uc2sb(tet : uc_l) + x'00'
     c                   return    tet_rpg_process_page(tet:doc:pagno:optlist0)

     p RTET_process_...
     p page            e
      ********************************************************************************************
     p RTET_get_...
     p tetml           b                   export

     d RTET_get_...
     d tetml           pi              *
     d  tet                            *   value
     d  doc                          10i 0 value
     d  len                          10i 0
     d  tet_optlist                        value like(r_optlist_u)

     d optlist0        s             +1    like(r_optlist)
     d value           s                   like(r_text_long_s) based(value_p)
     d inputformat0    s             +1    like(r_text)
     d rtnval          s          32767    based(rtnval_p)
     d rtnlen          s             10i 0
     d uc_l            s                   like(r_text_long_u)

      /free
          uc_l = tet_optlist;
          optlist0 = uc2sb(tet : uc_l) + x'00';
          value_p = tet_rpg_get_tetml(tet:doc:len:optlist0);
          uc_l = %ucs2('ebcdicutf8');
          inputformat0 = uc2sb(tet : uc_l) + x'00';
          uc_l = %ucs2('outputformat=utf16');
          optlist0 = uc2sb(tet : uc_l) + x'00';

          return tet_rpg_convert_to_unicode(
                        tet :
                        inputformat0 :
                        value :
                        0 :
                        rtnlen :
                        optlist0 );
      /end-free

     p RTET_get_...
     p tetml           e
      *********************************************************************************************
     p RTET_convert_to_unicode...
     p                 b                   export

     d RTET_convert_to_unicode...
     d                 pi              *
     d  tet                            *   value
     d  inputformat                        value like(r_text_u)
     d  inputstring                        like(r_text_long_s) options(*varsize)
     d  inputlen                     10i 0 value
     d  outputlen                    10i 0
     d  optlist                            value like(r_optlist_u)
	
     d inputformat0    s             +1    like(r_text)
     d optlist0        s             +1    like(r_optlist)
     d uc_l            s                   like(r_text_long_u)
      /free
          uc_l = optlist;
          optlist0 = uc2sb(tet : uc_l) + x'00';
          uc_l = inputformat;
          inputformat0 = uc2sb(tet : uc_l) + x'00';

          return tet_rpg_convert_to_unicode(
                        tet :
                        inputformat0 :
                        inputstring :
                        inputlen :
                        outputlen :
                        optlist0);
      /end-free
	
     p RTET_convert_to_unicode...
     p                 e
      *********************************************************************************************
     p RTET_get_char_info...
     p                 b                   export
     d RTET_get_char_info...
     d                 pi              *
     d  tet                            *   value
     d  tet_page                     10i 0 value

     d*  ci             ds                  based(ci_p)
     d* ci_uv                         10u 0                                      current character in UTF-32
     d* ci_type                       10i 0                                      character type, see TET_CT_* above
     d* ci_unknown                    10i 0                                      1 if glyph couldn't be mapped to Unicode
     d* ci_attributes                 10i 0                                      character attributes, see TET_ATTR_* con
     d* ci_x                           8f                                        x position of the char's reference point
     d* ci_y                           8f                                        y position of the char's reference point
     d* ci_width                       8f                                        horizontal character extent
      * height added
     d* ci_height                      8f                                        vertical character extent
     d* ci_alpha                       8f                                        text baseline angle in degrees
     d* ci_beta                        8f                                        vertical character slanting angle
     d* ci_fontid                     10i 0                                      pCOS font id
      * taken out
     d* ci_filler2                    10i 0                                      Filler
     d* ci_fontsize                    8f                                        size of the font
     d* ci_colorid                    10i 0                                      unique text color id
     d* ci_textrender                 10i 0                                      text rendering mode, see TET_TR_* above

      *
     c*                   eval      ci_p = tet_rpg_get_char_info(tet:tet_page)
     c*                   return    ci_p
     c                   return    tet_rpg_get_char_info(tet:tet_page)
      *
     p RTET_get_char_info...
     p                 e
      *********************************************************************************************
     p RTET_get_color_info...
     p                 b                   export
     d RTET_get_color_info...
     d                 pi              *
     d  tet                            *   value
     d  tet_doc                      10i 0 value
     d  tet_color                    10i 0 value
     d  tet_optlist                        value like(r_optlist_u)
      *
     c                   return    tet_rpg_get_color_info
     c                               (tet:tet_doc:tet_color:tet_optlist)
      *
     p RTET_get_color_info...
     p                 e
      *********************************************************************************************
     p RTET_get_errnum...
     p                 b                   export
     d RTET_get_errnum...
     d                 pi            10i 0
     d  tet                            *   value
      *
     c                   return    tet_rpg_get_errnum(tet)
      *
     p RTET_get_errnum...
     p                 e
      *********************************************************************************************
     p RTET_get_image_info...
     p                 b                   export
     d RTET_get_image_info...
     d                 pi              *
     d  tet                            *   value
     d  tet_page                     10i 0 value
      *
     c                   return    tet_rpg_get_image_info(tet:tet_page)
      *
     p RTET_get_image_info...
     p                 e
      *********************************************************************************************
     p RTET_get_text...
     p                 b                   export
     d RTET_get_text...
     d                 pi              *
     d  tet                            *   value
     d  tet_page                     10i 0 value
     d  tet_len                      10i 0
      *
     c                   return    tet_rpg_get_text(tet:tet_page:tet_len)
      *
     p RTET_get_text...
     p                 e
      *********************************************************************************************
     p RTET_close_document...
     p                 b                   export
     d RTET_close_document...
     d                 pi            10i 0
     d  tet                            *   value
     d  tet_doc                      10i 0 value
      *
     c                   return    tet_rpg_close_document(tet:tet_doc)
      *
     p RTET_close_document...
     p                 e
      *********************************************************************************************
     p RTET_close_page...
     p                 b                   export
     d RTET_close_page...
     d                 pi            10i 0
     d  tet                            *   value
     d  tet_page                     10i 0 value
      *
     c                   return    tet_rpg_close_page(tet:tet_page)
      *
     p RTET_close_page...
     p                 e

