      **************************************************************************
      *       Copyright (c) 2005-2022 PDFlib GmbH. All rights reserved.        *
      **************************************************************************
      * This software may not be copied or distributed except as expressly     *
      * authorized by PDFlib GmbH's general license agreement or a custom      *
      * license agreement signed by PDFlib GmbH.                               *
      * For more information about licensing please refer to www.pdflib.com.   *
      **************************************************************************

     H DEBUG(*YES) DFTACTGRP(*NO) BNDDIR('TETLIB/TETLIB')
     H COPYRIGHT('(c) PDFlib GmbH (www.pdflib.com)')
      *********************************************************************************************
      *   TET sample application for dumping PDF information in the XML language TETML
      *
      *   Note: All strings passed into TETlib are unicode strings with varying length.
      *         Use the %UCS2 build in function to convert a single byte string into a unicode string.
      *         All strings returned from TETlib are unicode strings with varying length.
      *         Use the %CHAR build in function to convert a unicode string to a single byte string.
      *********************************************************************************************
     d/copy QRPGLESRC,TETLIB
     d/copy QRPGLESRC,IFSIO
      *********************************************************************************************
      * global option list
     d globaloptlist   c                   %ucs2('-
     d                                     searchpath={../../../resource/cmap}')

      * document-specific option list
     d basedocoptlist  c                   %ucs2('')

      * page-specific option list
      * Remove the tetml= option if you don't need font and geometry information
     d pageoptlist     c                   %ucs2('granularity=word -
     d                                     tetml={glyphdetails={all}}')

      * set this to 1 to generate TETML output in memory
     d inmemory        c                   0

     d tet             s               *
     d docoptlist      s           1024c     varying
     d pageno          s             10i 0
     d n_pages         s             10i 0
     d doc             s             10i 0
     d outfd           s             10i 0
     d len             s             10i 0
     d tetml           s               *
     d error           s             52
     d txt             s             52
     d outfilename     s            256    varying
     d n               s              1c   varying inz(%ucs2(''))
      *********************************************************************************************
     c     *entry        plist
     c                   parm                    parm1           128
     c                   parm                    parm2           128
      *
     c                   if        %parms<1 or %parms>2
     c                   eval      error='usage: CALL PGM(TETML) '+
     c                                    'PARM(<pdffile> <xmlfile>)'
     c                   exsr      exit
     c                   endif
      *
     c                   eval      outfilename=%trim(parm2)
      *
     c                   eval      tet=TET_new
     c                   if        tet=*null
     c                   eval      error='tetml: out of memory'
     c                   exsr      exit
     c                   endif
      *
     c                   monitor
      *
     c                   callp     TET_set_option(tet:globaloptlist)
      *
     c                   if        inmemory=1
     c                   eval      docoptlist=%ucs2('tetml={} ')+basedocoptlist
     c                   else
     c                   eval      docoptlist=%ucs2('tetml={filename={'+
     c                                   %trim(parm2)+'}} ')+basedocoptlist
     c                   endif
      *
     c                   eval      doc=TET_open_document(tet:
     c                                     %ucs2(%trim(parm1)):docoptlist)
     c                   if        doc=-1
     c                   eval      error='Error '+
     c                               %char(TET_get_errnum(tet))+' in '+
     c                               %char(TET_get_apiname(tet))+'(): '+
     c                               %char(TET_get_errmsg(tet))
     c                   callp     TET_delete(tet)
     c                   exsr      exit
     c                   endif
      *
      * get number of pages in the document
     c                   eval      n_pages=TET_pcos_get_number(tet:doc:
     c                                     %ucs2('length:pages'))
      *
      * loop over pages in the document
     c                   do        n_pages       pageno
     c                   callp     TET_process_page(tet:doc:pageno:pageoptlist)
     c                   enddo
      *
      * This could be combined with the last page-related call
     c                   callp     TET_process_page(tet:doc:0:
     c                                      %ucs2('tetml={trailer}'))
      *
     c                   if        inmemory=1
     c                   eval      outfd=open(outfilename:
     c                                     O_WRONLY+O_CREAT+O_TRUNC+O_EXCL:
     c                                     S_IRWXU+S_IRWXG)
     c                   if        outfd<0
     c                   eval      error='Couldn''t open "'+outfilename+'".'
     c                   callp     TET_delete(tet)
     c                   exsr      exit
     c                   endif
      * Retrieve the generated TETML data from memory. Since we have
      * only a single call the result will contain the full TETML.
     c                   eval      tetml =TET_get_tetml(tet: doc: len: n)
     c                   if        tetml=*null
     c                   eval      txt='tetml: couldn''t retrieve TETML data'
     c     txt           dsply
     c                   eval      txt = %char(TET_get_errmsg(tet))
     c     txt           dsply
     c                   exsr      exit
     c                   endif
     c                   callp     write(outfd:tetml:len)
     c                   callp     close(outfd)
     c                   endif
      *
     c                   callp     TET_close_document(tet:doc)
      *
     c                   on-error
     c                   eval      txt='TET exception occured in TETML:'
     c     txt           dsply
     c                   eval      txt=
     c                               %char(TET_get_errnum(tet))+' in '+
     c                               %char(TET_get_apiname(tet))+'(): '+
     c                               %char(TET_get_errmsg(tet))
     c     txt           dsply
     c                   endmon
     c                   callp     TET_delete(tet)
     c                   exsr      exit
      *********************************************************************************************
     c     geterrmsg     begsr
     c                   eval      error = %char(TET_get_errmsg(tet))
     c                   endsr
      *********************************************************************************************
     c     exit          begsr
     c                   if        error<>*blanks
     c                   eval      error='Error: '+error
     c     error         dsply
     c                   endif
     c                   seton                                        lr
     c                   return
     c                   endsr
