/*---------------------------------------------------------------------------*
 |          Copyright (c) 2005-2022 PDFlib GmbH. All rights reserved.        |
 +---------------------------------------------------------------------------+
 |    This software may not be copied or distributed except as expressly     |
 |    authorized by PDFlib GmbH's general license agreement or a custom      |
 |    license agreement signed by PDFlib GmbH.                               |
 |    For more information about licensing please refer to www.pdflib.com.   |
 *---------------------------------------------------------------------------*/

/*
 * TETException Java class
 */

package com.pdflib;

/** Text and Image Extraction Toolkit (TET):
    Toolkit for extracting Text, Images, and Metadata from PDF Documents<br>

    Exception handling for TET.
    @author Rainer Schaaf
    @version 6.0
*/

public class TETException extends Exception {
    /** PDFlibException()
     */
    public TETException() {
	super();
    }

    /** PDFlibException(String msg)
     * @param msg msg
     */
    public TETException(String msg) {
	super(msg);
    }

    /** PDFlibException(String msg, int errnum, String apiname)
     * @param msg msg
     * @param errnum errnum
     * @param apiname apiname
     */
    public TETException(String msg, int errnum, String apiname) {
	super(msg);
	tet_errnum = errnum;
	tet_apiname = apiname;
    }

    /** Map standard getMessage method to get_errmsg.
     * 
     * @return	A string describing the error, or an empty string if the
     * 		last API call didn't cause any error. 
     */
    public String get_errmsg() {
        return super.getMessage();
    }

    /** Get the error number of the exception.
     * @return	The exception's error number. 
     */
    public int get_errnum() {
	return tet_errnum;
    }

    /** Get the name of the API function which caused the exception.
     * @return	The name of an API function. 
     */
    public String get_apiname() {
	return tet_apiname;
    }

    /** private pdflib_errnum
     */
    private int tet_errnum;
    /** private pdflib_apiname
     */
    private String tet_apiname;
}
