#---------------------------------------------------------------------------#
#          Copyright (c) 1997-2022 PDFlib GmbH. All rights reserved.        #
#---------------------------------------------------------------------------#
#    This software may not be copied or distributed except as expressly     #
#    authorized by PDFlib GmbH's general license agreement or a custom      #
#    license agreement signed by PDFlib GmbH.                               #
#    For more information about licensing please refer to www.pdflib.com.   #
#---------------------------------------------------------------------------#


package PDFlib::TET;

use strict;
use Carp;
use warnings::register;

use tetlib_pl 6.0;
our $VERSION = 6.0;

use constant CT_NORMAL =>    0;
use constant CT_SEQ_START => 1;
use constant CT_SEQ_CONT =>  10;
use constant CT_INSERTED =>  12;

use constant ATTR_NONE =>                   0x00000000;
use constant ATTR_SUB =>                    0x00000001;
use constant ATTR_SUP =>                    0x00000002;
use constant ATTR_DROPCAP =>                0x00000004;
use constant ATTR_SHADOW =>                 0x00000008;
use constant ATTR_DEHYPHENATION_PRE =>      0x00000010;
use constant ATTR_DEHYPHENATION_ARTIFACT => 0x00000020;
use constant ATTR_DEHYPHENATION_POST =>     0x00000040;
use constant ATTR_ARTIFACT =>               0x00000100;
use constant ATTR_ANNOTATION =>             0x00000200;
use constant ATTR_PATTERN =>                0x00000400;
use constant ATTR_SOFTMASK =>               0x00000800;

use constant TR_FILL =>            0;
use constant TR_STROKE =>          1;
use constant TR_FILLSTROKE =>      2;
use constant TR_INVISIBLE =>       3;
use constant TR_FILL_CLIP =>       4;
use constant TR_STROKE_CLIP =>     5;
use constant TR_FILLSTROKE_CLIP => 6;
use constant TR_CLIP =>            7;

use constant IF_TIFF  => 10;
use constant IF_JPEG  => 20;
use constant IF_JP2   => 31;
use constant IF_JPF   => 32;
use constant IF_J2K   => 33;
use constant IF_JBIG2 => 50;

sub new {
    my $class = shift;
    my $self = {};
    my $tet = TET_new();

    bless $self, $class;
    $self->{tet} = $tet;
    TET_set_option($tet, "binding={Perl} objorient");

    return $self;
}

sub DESTROY {
    my $self = shift;

    TET_delete($self->{tet}) if $self->{tet};
}

# Automatically generated methods

sub close_document {
    my $self = shift;
    eval {
	TET_close_document($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
}

sub close_page {
    my $self = shift;
    eval {
	TET_close_page($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
}

sub convert_to_unicode {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_convert_to_unicode($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub create_pvf {
    my $self = shift;
    eval {
	TET_create_pvf($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
}

sub delete_pvf {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_delete_pvf($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub get_apiname {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_get_apiname($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub get_char_info {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_get_char_info($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub get_color_info {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_get_color_info($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub get_errmsg {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_get_errmsg($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub get_errnum {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_get_errnum($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub get_image_data {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_get_image_data($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub get_image_info {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_get_image_info($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub get_text {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_get_text($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub info_pvf {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_info_pvf($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub open_document {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_open_document($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub open_page {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_open_page($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub pcos_get_number {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_pcos_get_number($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub pcos_get_string {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_pcos_get_string($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub pcos_get_stream {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_pcos_get_stream($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub set_option {
    my $self = shift;
    eval {
	TET_set_option($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
}

sub write_image_file {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_write_image_file($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub process_page {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_process_page($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}

sub get_tetml {
    my $self = shift;
    my $ret;
    eval {
	$ret = TET_get_tetml($self->{tet}, @_);
    };
    if ($@) {
	croak($@);
    }
    return($ret);
}
