#---------------------------------------------------------------------------#
#          Copyright (c) 2005-2022 PDFlib GmbH. All rights reserved.        #
#---------------------------------------------------------------------------#
#    This software may not be copied or distributed except as expressly     #
#    authorized by PDFlib GmbH's general license agreement or a custom      #
#    license agreement signed by PDFlib GmbH.                               #
#    For more information about licensing please refer to www.pdflib.com.   #
#---------------------------------------------------------------------------#

package tetlib_pl;
require Exporter;
require DynaLoader;
$VERSION=6.0;
@ISA = qw(Exporter DynaLoader);
package tetlibc;
bootstrap tetlib_pl;
var_tetlib_init();
@EXPORT = qw( );

# ---------- BASE METHODS -------------

package tetlib_pl;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package tetlib_pl;

*TET_delete = *tetlibc::TET_delete;
*TET_get_char_info = *tetlibc::TET_get_char_info;
*TET_get_color_info = *tetlibc::TET_get_color_info;
*TET_get_image_info = *tetlibc::TET_get_image_info;
*TET_new = *tetlibc::TET_new;

*TET_close_document = *tetlibc::TET_close_document;
*TET_close_page = *tetlibc::TET_close_page;
*TET_convert_to_unicode = *tetlibc::TET_convert_to_unicode;
*TET_create_pvf = *tetlibc::TET_create_pvf;
*TET_delete_pvf = *tetlibc::TET_delete_pvf;
*TET_get_apiname = *tetlibc::TET_get_apiname;
*TET_get_char_info = *tetlibc::TET_get_char_info;
*TET_get_color_info = *tetlibc::TET_get_color_info;
*TET_get_errmsg = *tetlibc::TET_get_errmsg;
*TET_get_errnum = *tetlibc::TET_get_errnum;
*TET_get_image_data = *tetlibc::TET_get_image_data;
*TET_get_image_info = *tetlibc::TET_get_image_info;
*TET_get_text = *tetlibc::TET_get_text;
*TET_info_pvf = *tetlibc::TET_info_pvf;
*TET_open_document = *tetlibc::TET_open_document;
*TET_open_page = *tetlibc::TET_open_page;
*TET_pcos_get_number = *tetlibc::TET_pcos_get_number;
*TET_pcos_get_string = *tetlibc::TET_pcos_get_string;
*TET_pcos_get_stream = *tetlibc::TET_pcos_get_stream;
*TET_set_option = *tetlibc::TET_set_option;
*TET_write_image_file = *tetlibc::TET_write_image_file;
*TET_process_page = *tetlibc::TET_process_page;
*TET_get_tetml = *tetlibc::TET_get_tetml;

@EXPORT = qw(
TET_new
TET_delete
TET_close_document
TET_close_page
TET_convert_to_unicode
TET_create_pvf
TET_delete_pvf
TET_get_apiname
TET_get_char_info
TET_get_color_info
TET_get_errmsg
TET_get_errnum
TET_get_image_data
TET_get_image_info
TET_get_text
TET_info_pvf
TET_open_document
TET_open_page
TET_pcos_get_number
TET_pcos_get_string
TET_pcos_get_stream
TET_set_option
TET_write_image_file
TET_process_page
TET_get_tetml

);
