#!/usr/bin/perl
# TET sample application for dumping PDF information in the XML language TETML

use PDFlib::TET;
use strict;

# global option list */
my $globaloptlist = "searchpath={{../data} {../../../resource/cmap}}";

# document-specific option list */
my $basedocoptlist = "";

# page-specific option list */
# Remove the tetml= option if you don't need font and geometry information */
my $pageoptlist = "granularity=word tetml={glyphdetails={all}}";

# set this to 1 to generate TETML output in memory */
my $inmemory = 0;

eval  {
    my $tet;
    my $tetml;
    my $pageno;
    my $n_pages;
    my $docoptlist;
    my $doc;
    my $len;

    if ($#ARGV !=1) {
        die("usage: tetml.pl <pdffilename> <tetmlfilename>\n");
    }

    $tet = new PDFlib::TET;

    $tet->set_option($globaloptlist);

    if ($inmemory) {
        $docoptlist = sprintf("tetml={} %s", $basedocoptlist);
    } else {
        $docoptlist = sprintf("tetml={filename={%s}} %s",
            $ARGV[1], $basedocoptlist);
    }

    $doc = $tet->open_document($ARGV[0], $docoptlist);

    if ($doc == -1) {
        die(sprintf("Error %d in %s(): %s\n",
            $tet->get_errnum(), $tet->get_apiname(), $tet->get_errmsg()));
    }

    $n_pages = $tet->pcos_get_number($doc, "length:pages");

    # loop over pages in the document */
    for ($pageno = 1; $pageno <= $n_pages; ++$pageno) {
        $tet->process_page($doc, $pageno, $pageoptlist);
    }

    # This could be combined with the last page-related call */
    $tet->process_page($doc, 0, "tetml={trailer}");

    if ($inmemory) {
        my $fname = $ARGV[1];
        open(FP, ">$fname") || die(
            sprintf("tetml: couldn't open output file '%s'\n", $fname));

        # Retrieve the generated TETML data from memory. Since we have
        # only a single call the result will contain the full TETML.
        #/

        $tetml = $tet->get_tetml($doc, "");
        if (!$tetml) {
            die("tetml: couldn't retrieve TETML data\n");
        }

        print FP $tetml;
        close(FP);
    }

    $tet->close_document($doc);
};

if ($@) {
    printf("TET Exception occurred:\n");
    printf("Error $@\n");
    exit(1);
}
