<?php
/* 
 *  Simple PDF glyph dumper based on PDFlib TET
 */


/* global option list */
$globaloptlist = "searchpath={../data ../../data ../../../resource/cmap}";

/* document-specific option list */
$docoptlist = "";

/* page-specific option list */
$pageoptlist = "granularity=word";

$pageno = 0;

try {
    $infilename = "TET-datasheet.pdf";
    $outfilename = "TET-datasheet.info.txt";


    $tet = new TET();

    if (!$outfp = fopen($outfilename, "wb")) {
        die("Couldn't open output file '" . $outfilename . "'\n");
    }


    $tet->set_option($globaloptlist);

    $doc = $tet->open_document($infilename, $docoptlist);

    if ($doc == -1) {
        die("Error ". $tet->get_errnum() . " in " . 
            $tet->get_apiname() . "(): " . $tet->get_errmsg() . "\n");
    }

    /* get number of pages in the document */
    $n_pages = $tet->pcos_get_number($doc, "length:pages");

    # print UTF-8 BOM
    fprintf($outfp, "%c%c%c", 0xef, 0xbb, 0xbf);

    /* loop over pages in the document */
    for ($pageno = 1; $pageno <= $n_pages; ++$pageno) {
    $previouscolorid= -1;

    $page = $tet->open_page($doc, $pageno, $pageoptlist);

    if ($page == -1) {
        fwrite(STDERR, "Error ". $tet->get_errnum() ." in ".
        $tet->get_apiname() . "(): " . $tet->get_errmsg() . "\n");
        next;                        # try next page
    }

    # Administrative information
    fprintf($outfp, "[ Document: '%s' ]\n",
    $tet->pcos_get_string($doc, "filename"));

    fprintf($outfp, "[ Document options: '%s' ]\n", $docoptlist);

    fprintf($outfp, "[ Page options: '%s' ]\n", $pageoptlist);

    fprintf($outfp, "[ ----- Page %d ----- ]\n", $pageno);


    # Retrieve all text fragments
    while (($text = $tet->get_text($page)) != "")
    {
        fprintf($outfp, "[%s]\n", $text);  # print the retrieved text


        # Loop over all glyphs and print their details
        while ($ci = $tet->get_char_info($page))
        {
        # Fetch the font name with pCOS (based on its ID)
        $fontname = $tet->pcos_get_string($doc,
            "fonts[" . $ci->{"fontid"} . "]/name");

        # Print the Unicode value ...
        fprintf($outfp, "U+%04X", $ci->{"uv"});

        # ...and the character itself if it is ASCII
        if ($ci->{"uv"} >= 0x20 && $ci->{"uv"} <= 0x7F) {
            fprintf($outfp, " '%c'", $ci->{"uv"});
        } else {
            fprintf($outfp, " ???");
        }

        # Print font name, size, and position
        fprintf($outfp, " %s size=%.2f x=%.2f y=%.2f",
            $fontname, $ci->{"fontsize"}, $ci->{"x"}, $ci->{"y"});

        # Print the color id 
        fprintf($outfp, " colorid=%d", $ci->colorid);

        # Check whether the text color changed 
        if ($ci->colorid != $previouscolorid){
          print_color_value($outfp, $tet, $doc, $ci->colorid);
          $previouscolorid = $ci->colorid;
        }

        # Examine the "type" member
        if ($ci->{"type"} == TET::CT_SEQ_START) {
            fprintf($outfp, " ligature_start");
        }
        elseif ($ci->{"type"} == TET::CT_SEQ_CONT) {
            fprintf($outfp, " ligature_cont");
        }

        # Separators are only inserted for granularity > word
        elseif ($ci->{"type"} == TET::CT_INSERTED) {
            fprintf($outfp, " inserted");
        }

        # Examine the bit flags in the "attributes" member
        if ($ci->{"attributes"} != TET::ATTR_NONE)
        {
            if ($ci->{"attributes"} & TET::ATTR_SUB) {
                fprintf($outfp, "/sub");
            }
            if ($ci->{"attributes"} & TET::ATTR_SUP) {
                fprintf($outfp, "/sup");
            }
            if ($ci->{"attributes"} & TET::ATTR_DROPCAP) {
                fprintf($outfp, "/dropcap");
            }
            if ($ci->{"attributes"} & TET::ATTR_SHADOW) {
                fprintf($outfp, "/shadow");
            }
            if ($ci->{"attributes"} & TET::ATTR_DEHYPHENATION_PRE) {
                fprintf($outfp, "/dehyphenation_pre");
            }
            if ($ci->{"attributes"} & TET::ATTR_DEHYPHENATION_ARTIFACT) {
                fprintf($outfp, "/dehyphenation_artifact");
            }
            if ($ci->{"attributes"} & TET::ATTR_DEHYPHENATION_POST) {
                fprintf($outfp, "/dehyphenation_post");
            }
            if ($ci->{"attributes"} & TET::ATTR_ARTIFACT) {
                fprintf($outfp, "/Artifact");
            }
        }

        fprintf($outfp, "\n");
        }

        fprintf($outfp, "\n");
    }
    if ($tet->get_errnum() != 0) {
        print("Error ". $tet->get_errnum() . " in " . 
            $tet->get_apiname() . "(): on page $pageno" 
            . $tet->get_errmsg() . "\n");
    }

    $tet->close_page($page);
    }

    fclose($outfp);

    $tet->close_document($doc);
}
catch (TETException $e) {
    $addpage = ""; 
    if ($pageno > 0) $addpage = " on page " . $pageno; 
    die("TET exception occurred in glyphinfo sample:\n" .
        "[" . $e->get_errnum() . "] " . $e->get_apiname() . 
        $addpage  . ": " . $e->get_errmsg() . "\n");
}
catch (Throwable $e) {
    die(get_class($e) . " occurred in glyhinfo sample:\n" . $e->getMessage() . "\n");
}

$tet = 0;

function print_color_value($outfp, $tet, $doc, $colorid)
{

    /* We handle only the fill color, but ignore the stroke color.
     * The stroke color can be retrieved analogously with the
     * keyword "stroke".
     */
    $colorinfo = $tet->get_color_info($doc, $colorid, "usage=fill");

    if ($colorinfo->colorspaceid == -1 && $colorinfo->patternid == -1)
    {
    fprintf($outfp, " (not filled)");
    return;
    }

    fprintf($outfp, " (");

    if ($colorinfo->patternid != -1)
    {
    $patterntype =  $tet->pcos_get_number($doc, 
        sprintf("patterns[%d]/PatternType", $colorinfo->patternid));

    if ($patterntype == 1)	/* Tiling pattern */
    {
        $painttype =  $tet->pcos_get_number($doc, 
            sprintf("patterns[%d]/PaintType", $colorinfo->patternid));
        if ($painttype == 1)
        {
        fprintf($outfp, "colored Pattern)");
        return;
        }
        else if ($painttype == 2)
        {
        fprintf($outfp, "uncolored Pattern, base color: ");
        /* FALLTHROUGH to colorspaceid output */
        }
    }
    else if ($patterntype == 2)	/* Shading pattern */
    {
        $shadingtype =  $tet->pcos_get_number($doc,
            sprintf("patterns[%d]/Shading/ShadingType",
            $colorinfo->patternid));

        fprintf($outfp, "shading Pattern, ShadingType=%d)", $shadingtype);
        return;
    }
    }

    $csname = $tet->pcos_get_string($doc, sprintf("colorspaces[%d]/name",
        $colorinfo->colorspaceid));

    fprintf($outfp, "%s", $csname);

    /* Emit more details depending on the colorspace type */
    if ($csname == "ICCBased")
    {
    $iccprofileid = $tet->pcos_get_number($doc,
                sprintf("colorspaces[%d]/iccprofileid",
                $colorinfo->colorspaceid));

    $errormessage = $tet->pcos_get_string($doc,
            sprintf("iccprofiles[%d]/errormessage", $iccprofileid));

    /* Check whether the embedded profile is damaged */
    if ($errormessage)
    {
        fprintf($outfp, " (%s)", $errormessage);
    }
    else
    {
        $profilename =
        $tet->pcos_get_string($doc,
            sprintf("iccprofiles[%d]/profilename", $iccprofileid));
        fprintf($outfp, " '%s'", $profilename);

        $profilecs = $tet->pcos_get_string($doc,
            sprintf("iccprofiles[%d]/profilecs",
                    $iccprofileid));
        fprintf($outfp, " '%s'", $profilecs);
    }
    }
    else if ($csname == "Separation")
    {
    $colorantname =
        $tet->pcos_get_string($doc, sprintf("colorspaces[%d]/colorantname",
            $colorinfo->colorspaceid));
    fprintf($outfp, " '%s'", $colorantname);
    }
    else if ($csname == "DeviceN")
    {
    fprintf($outfp, " ");

    for ($i=0; $i < count($colorinfo->compontents); $i++)
    {
        $colorantname =
        $tet->pcos_get_string($doc,
            sprintf("colorspaces[%d]/colorantnames[%d]",
                $colorinfo->colorspaceid, $i));

        fprintf($outfp, "%s", $colorantname);

        if ($i != count($colorinfo->components)-1)
        fprintf($outfp, "/");
    }
    }
    else if ($csname ==  "Indexed")
    {
        $baseid =
             $tet->pcos_get_number($doc, sprintf("colorspaces[%d]/baseid",
            $colorinfo->colorspaceid));

        $csname = $tet->pcos_get_string($doc, 
        sprintf("colorspaces[%d]/name", $baseid));

        fprintf($outfp, " %s", $csname);

    }

    fprintf($outfp, " ");
    for ($i=0; $i < count($colorinfo->components); $i++)
    {
    fprintf($outfp, "%g", $colorinfo->components[$i]);

    if ($i != count($colorinfo->components)-1)
        fprintf($outfp, "/");
    }
    fprintf($outfp, ")");
}
?>
