<?php
/*
 * TET sample application for dumping PDF information in the XML language TETML
 *
 */

/* global option list */
$globaloptlist = "searchpath={../data ../../data ../../../resource/cmap}";

/* document-specific option list */
$basedocoptlist = "";

/* page-specific option list */
/* Remove the tetml= option if you don't need font and geometry information */
$pageoptlist = "granularity=word tetml={glyphdetails={all}}";

/* set this to 1 to generate TETML output in memory */
$inmemory = 0;


try {
    $infilename = "TET-datasheet.pdf";
    $outfilename = "TET-datasheet.tetml";

    $tet = new TET();

    $tet->set_option($globaloptlist);

    if ($inmemory) {
        $docoptlist = sprintf("tetml={} %s", $basedocoptlist);
    } else {
        $docoptlist = sprintf("tetml={filename={%s}} %s",
            $outfilename, $basedocoptlist);
    }

    $doc = $tet->open_document($infilename, $docoptlist);

    if ($doc == -1) {
        die(sprintf("Error %d in %s(): %s\n",
            $tet->get_errnum(), $tet->get_apiname(), $tet->get_errmsg()));
    }

    $n_pages = $tet->pcos_get_number($doc, "length:pages");

    /* loop over pages in the document */
    for ($pageno = 1; $pageno <= $n_pages; ++$pageno) {
        $tet->process_page($doc, $pageno, $pageoptlist);
    }

    /* This could be combined with the last page-related call */
    $tet->process_page($doc, 0, "tetml={trailer}");

    if ($inmemory) {
        $fname = $outfilename;
        if (!$fp = fopen($fname, "wb")) {
            die(sprintf("tetml: couldn't open output file '%s'\n", $fname));
        }

        /* Retrieve the generated TETML data from memory. Since we have
         * only a single call the result will contain the full TETML.
         */

        $tetml = $tet->get_tetml($doc, "");
        if (!$tetml) {
            die("tetml: couldn't retrieve TETML data\n");
        }

        fwrite($fp, $tetml);
        fclose($fp);
    }

    $tet->close_document($doc);
}
catch (TETException $e) {
    die("TET exception occurred in tetml sample:\n" .
            "[" . $e->get_errnum() . "] " . $e->get_apiname() . ": " .
            $e->get_errmsg() . "\n");
}
catch (Throwable $e) {
    die(get_class($e) . " occurred in tetml sample:\n" .  $e->getMessage() . "\n");
} 

$tet = 0;
?>
