#!/usr/bin/env ruby
# TET sample application for dumping PDF information with pCOS
#

require 'TET'

begin
    if (ARGV.length != 1)
        raise "usage: dumper.rb <filename>"
    end

    tet = TET.new

    docoptlist = "requiredmode=minimum"
    globaloptlist = ""
    # This is where input files live. Adjust as necessary.
    searchpath = "{../data}"

    tet.set_option(globaloptlist)

    tet.set_option("searchpath=" + searchpath)


    if ((doc = tet.open_document(ARGV[0], docoptlist)) == -1)
        raise "ERROR: " + tet.get_errmsg()
    end

    # --------- general information (always available)

    pcosmode = tet.pcos_get_string(doc, "pcosmodename")

    printf("   File name: %s\n", tet.pcos_get_string(doc, "filename"))

    printf(" PDF version: %s\n",
        tet.pcos_get_string(doc, "pdfversionstring"))

    printf("  Encryption: %s\n",
        tet.pcos_get_string(doc, "encrypt/description"))

    printf("   Master pw: %s\n",
        (tet.pcos_get_number(doc, "encrypt/master") != 0) ? "yes" : "no")

    printf("     User pw: %s\n",
        (tet.pcos_get_number(doc, "encrypt/user") != 0) ? "yes" : "no")

    printf("Text copying: %s\n",
        (tet.pcos_get_number(doc, "encrypt/nocopy") != 0) ? "no" : "yes")

    printf("  Linearized: %s\n",
        (tet.pcos_get_number(doc, "linearized") != 0) ? "yes" : "no")

    if (pcosmode == "minimum")
        printf("Minimum mode: no more information available\n\n")
        return
    end

    # --------- more details (requires at least user password)

    printf("PDF/X status: %s\n", tet.pcos_get_string(doc, "pdfx"))

    printf("PDF/A status: %s\n", tet.pcos_get_string(doc, "pdfa"))

    printf("    XFA data: %s\n",
        (tet.pcos_get_string(doc, "type:/Root/AcroForm/XFA") != "null" ? "yes" : "no"))
                            
    printf("  Tagged PDF: %s\n\n",
        (tet.pcos_get_number(doc, "tagged") != 0) ? "yes" : "no")

    printf("No. of pages: %d\n",
        tet.pcos_get_number(doc, "length:pages"))

    printf(" Page 1 size: width=%g, height=%g\n",
        tet.pcos_get_number(doc, "pages[0]/width"),
        tet.pcos_get_number(doc, "pages[0]/height"))

    count = tet.pcos_get_number(doc, "length:fonts")
    printf("No. of fonts: %d\n", count)

    0.step(count-1,1) do |i|
        fonts = "fonts[" + i.to_i.to_s + "]/embedded"
        if (tet.pcos_get_number(doc, fonts))
            printf("embedded ")
        else
            printf("unembedded ")
        end

        fonts = "fonts[" + i.to_i.to_s + "]/type"
        printf("%s font ", tet.pcos_get_string(doc, fonts))
        fonts = "fonts[" + i.to_i.to_s + "]/name"
        printf("%s\n", tet.pcos_get_string(doc, fonts))
    end

    printf("\n")

    plainmetadata = tet.pcos_get_number(doc, "encrypt/plainmetadata") != 0

    if (pcosmode == "restricted" && !plainmetadata &&
            tet.pcos_get_number(doc, "encrypt/nocopy") != 0)
        printf("Restricted mode: no more information available\n\n")
        return
    end

    # --------- document info keys and XMP metadata (requires master pw
    # or plaintext metadata)

    count = tet.pcos_get_number(doc, "length:/Info")

    0.step(count-1,1) do |i|
        info = "type:/Info[" + i.to_i.to_s + "]"
        objtype = tet.pcos_get_string(doc, info)
        info = "/Info[" + i.to_i.to_s + "].key"
        key = tet.pcos_get_string(doc, info)
        len = 12 - key.length()

        len.step(1,-1) do |len|
            print " "
        end
        
        print key + ": "

        # Info entries can be stored as string or name objects
        if (objtype != "string" || objtype != "name")
            info = "/Info[" + i.to_i.to_s + "]"
            print "'" + tet.pcos_get_string(doc, info) + "'" + "\n"
        else
            info = "type:/Info[" + i.to_i.to_s + "]"
            print "(" + tet.pcos_get_string(doc, info) + " object)" + "\n"
        end
    end

    printf("\nXMP meta data: ")

    objtype = tet.pcos_get_string(doc, "type:/Root/Metadata")
    if (objtype == "stream")
        contents = tet.pcos_get_stream(doc, "", "/Root/Metadata")
        print contents.length.to_s + " UTF-8 bytes"
    else
        printf("not present\n\n")
    end

    tet.close_document(doc)
rescue TETException => pe
    print pe.backtrace.join("\n")
    printf("TET exception occurred in dumper:\n")
    print "[" + pe.get_errnum.to_s + "] " + pe.get_apiname + \
                        ": " + pe.get_errmsg + "\n"
rescue Exception => e
    print e.backtrace.join("\n") + "\n" + e.to_s + "\n"
ensure
    tet.delete() if tet
end
