    require 'TET'


    # file to extract text from
    infilename  = "TET-datasheet.pdf"

    # global option list
    globaloptlist = "searchpath={{../data} {../../../resource/cmap}}"

    # document-specific option list
    docoptlist = ""

    # page-specific option list
    pageoptlist = "granularity=page"

    # separator to emit after each chunk of text. This depends on the
    # application's needs for granularity=word a space character may be useful.
    separator = "\n"


    pageno = 0

    begin
	tet = TET.new

	tet.set_option(globaloptlist)

	doc = tet.open_document(infilename, docoptlist)

	if (doc == -1)
	    raise "Error " + tet.get_errnum().to_s + " in " \
		+ tet.get_apiname() + "(): " + tet.get_errmsg()
	end

	# get number of pages in the document
	n_pages = tet.pcos_get_number(doc, "length:pages")

	text = ""
	# loop over pages in the document
	1.upto(n_pages) do |pageno|
	    page = tet.open_page(doc, pageno, pageoptlist)

	    if (page == -1) 
		raise "Error " + tet.get_errnum().to_s + " in "
		    + tet.get_apiname() + "(): " + tet.get_errmsg()
	    end

	    # Retrieve all text fragments This is actually not required
	    # for granularity=page, but must be used for other granularities.
	    while ((t = tet.get_text(page)) != nil)
		text += t + separator
	    end

	    if (tet.get_errnum() != 0)
		print "Error " + tet.get_errnum().to_s + " in "
		+ tet.get_apiname() + "(): on page pageno " + tet.get_errmsg()
	    end

	    tet.close_page(page)
	end

	tet.close_document(doc)

	# and finaly show the retrieved text
	send_data text, :type => "text/plain", :disposition => "inline"

    rescue TETException => pe
	throw pe
    end
